/* Summary: glxclearcolor.c
 * Wraps <glClearColor> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glclearcolorstruct
{
    _glx_stream_header h;
    GLclampf r;
    GLclampf g;
    GLclampf b;
    GLclampf a;
} glclearcolorstruct;

void glClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
    glclearcolorstruct op;
    op.h.opcode = GLOP_CLEARCOLOR;
    op.h.len = 20;
    op.r = red;
    op.g = green;
    op.b = blue;
    op.a = alpha;

    _glx_schedule(&op, op.h.len);
}
