/* Summary: glxcolor3f.c
 * Wraps <glColor3f> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glcolorstruct
{
    _glx_stream_header h;
    GLfloat r;
    GLfloat g;
    GLfloat b;
} glcolorstruct;

void glColor3f (GLfloat red, GLfloat green, GLfloat blue)
{
    glcolorstruct op;
    op.h.opcode = GLOP_COLOR3FV;
    op.h.len = 16;
    op.r = red;
    op.g = green;
    op.b = blue;

    _glx_schedule(&op, op.h.len);
}
