/* Summary: glxcolor4f.c
 * Wraps <glColor4f> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glcolorstruct
{
    _glx_stream_header h;
    GLfloat r;
    GLfloat g;
    GLfloat b;
    GLfloat a;
} glcolorstruct;

void glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    glcolorstruct op;
    op.h.opcode = GLOP_COLOR4FV;
    op.h.len = 20;
    op.r = red;
    op.g = green;
    op.b = blue;
    op.a = alpha;

    _glx_schedule(&op, op.h.len);
}
