/* Summary: glxcullface.c
 * Wraps <glCullFace> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glcullfacestruct
{
    _glx_stream_header h;
    GLenum mode;
} glcullfacestruct;

void glCullFace(GLenum mode)
{
    glcullfacestruct op;
    op.h.opcode = GLOP_CULLFACE;
    op.h.len = 8;
    op.mode = mode;

    _glx_schedule(&op, op.h.len);
}
