/* Summary: glxdisable.c
 * Wraps <glDisable> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct gldisablestruct
{
    _glx_stream_header h;
    GLenum cap;
} gldisablestruct;

void glDisable(GLenum cap)
{
    gldisablestruct op;
    op.h.opcode = GLOP_DISABLE;
    op.h.len = 8;
    op.cap = cap;

    _glx_schedule(&op, op.h.len);
}
