/* Summary: glxenable.c
 * Wraps <glEnable> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glenablestruct
{
    _glx_stream_header h;
    GLenum cap;
} glenablestruct;

void glEnable(GLenum cap)
{
    glenablestruct op;
    op.h.opcode = GLOP_ENABLE;
    op.h.len = 8;
    op.cap = cap;

    _glx_schedule(&op, op.h.len);
}
