/* Summary: glxend.c
 * Wraps <glEnd> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glendstruct
{
    _glx_stream_header h;
} glendstruct;

void glEnd(void)
{
    glendstruct op;
    op.h.opcode = GLOP_END;
    op.h.len = 4;

    _glx_schedule(&op, op.h.len);
}
