/* Summary: glxgetstring.c
 * Wraps <glGetString> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <GL/glx_opcodes.h>
#include <stdlib.h>

typedef struct glgetstringstruct
{
    _glx_stream_header h;
    GLenum mode;
} glgetstringstruct;

static GLubyte * laststring = NULL;

GLubyte * glGetString(GLenum mode)
{
    glgetstringstruct op;
    op.h.opcode = GLXOP_GETSTRING | (short)0xF000;
    op.h.len = 8;
    op.mode = mode;
    _glx_schedule(&op, op.h.len);

    if (laststring)
        free(laststring);
        
    GLsizei l;
    laststring = _glx_retrieve(&l);
    return (laststring+4);
}
