/* Summary: glxmatrixmode.c
 * Wraps <glMatrixMode> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glmatrixmodestruct
{
    _glx_stream_header h;
    GLenum mode;
} glmatrixmodestruct;

void glMatrixMode(GLenum mode)
{
    glmatrixmodestruct op;
    op.h.opcode = GLOP_MATRIXMODE;
    op.h.len = 8;
    op.mode = mode;

    _glx_schedule(&op, op.h.len);
}
