/* Summary: glxscissor.c
 * Wraps <glScissor> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glscissorstruct
{
    _glx_stream_header h;
    GLint x;
    GLint y;
    GLsizei width;
    GLsizei height;
} glscissorstruct;

void glScissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    glscissorstruct op;
    op.h.opcode = GLOP_SCISSOR;
    op.h.len = 20;
    op.x = x;
    op.y = y;
    op.width = width;
    op.height = height;

    _glx_schedule(&op, op.h.len);
}
