/* Summary: glxvertexf.c
 * Wraps <glVertex>*f into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glvertex3fstruct
{
    _glx_stream_header h;
    GLfloat x;
    GLfloat y;
    GLfloat z;
} glvertex3fstruct;

void glVertex3f(GLfloat x, GLfloat y, GLfloat z)
{
    glvertex3fstruct op;
    op.h.opcode = GLOP_VERTEX3FV;
    op.h.len = 16;
    op.x = x;
    op.y = y;
    op.z = z;

    _glx_schedule(&op, op.h.len);
}
