/* Summary: glxviewport.c
 * Wraps <glViewport> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glviewportstruct
{
    _glx_stream_header h;
    GLuint x;
    GLuint y;
    GLuint width;
    GLuint height;
} glviewportstruct;

void glViewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    glviewportstruct op;
    op.h.opcode = GLOP_VIEWPORT;
    op.h.len = 20;
    op.x = x;
    op.y = y;
    op.width = width;
    op.height = height;

    _glx_schedule(&op, op.h.len);
}
