/* Summary: mglswapbuffer.c
 * Wraps <mglSwapBuffer> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <GL/mgl.h>
#include <GL/glx_opcodes.h>

typedef struct glswapbufferstruct
{
    _glx_stream_header h;
    GLenum mode;
} glswapbufferstruct;

void mglSwapBuffer(int mode)
{
    glswapbufferstruct op;
    op.h.opcode = GLOP_SWAPBUFFER;
    op.h.len = 8;
    op.mode = mode;

    _glx_schedule(&op, op.h.len);
}
