/* Summary: blit.c
 * Blitting extension
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <swgl/glbuffer.h>
#include <swgl/glpipe.h>
#include <swgl/gltexture.h>

void _gl_bitblt32(GLint srcx, GLint srcy, GLint dstx, GLint dsty, GLint dx, GLint dy)
{
    GLint x, y;

    GLint * basept = (GLint *) &(_gl_backbuffer->base[(dsty+dy-1) * _gl_backbuffer->pitch + dstx * _gl_backbuffer->stride]);
    GLint * srcpt = (GLint *) &(_gl_currenttexture->texture.base[(srcy+dy-1) * _gl_currenttexture->texture.pitch + srcx * _gl_currenttexture->texture.stride]);
    for (y = 0; y < dy; y++)
    {
        for (x = 0; x < dx; x++)
        {
            basept[x] = srcpt[x];
        }

        basept -= _gl_backbuffer->pitch >> 2;
        srcpt += _gl_currenttexture->texture.pitch >> 2;
    }

}
