/* Summary: fillbuffer_bgr15.c
 * Fills solid blocks in a R5G5B5 buffer
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <stdlib.h>
#include <swgl/gltexture.h>
#include <swgl/glbuffer.h>

void _gl_fillbuffer_b5g5r5(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest)
{
    GLubyte * basept = dest->base;
    GLint outwidth = dest->width;
    GLint outheight = dest->height;
    GLint outpitch = dest->pitch;
    if (a) {} // unused

    if (xoffset + width > outwidth) return;
    if (yoffset + height > outheight) return;

    int cr = r >> 3;
    int cg = g >> 3;
    int cb = b >> 3;

    GLshort col = cb | (cg << 5) | (cr << 10);

    for (int y = yoffset; y < yoffset+height; y++)
    {
         GLushort * outptr = (GLushort *) (basept + y * outpitch + xoffset * 2);
         for (int x = 0; x < width; x++)
             *outptr++ = col;
    }
}

