/* Summary: fillbuffer_bgr24.c
 * Fills solid blocks in a B8G8R8 buffer
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <stdlib.h>
#include <swgl/gltexture.h>
#include <swgl/glbuffer.h>

void _gl_fillbuffer_b8g8r8(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest)
{
    GLubyte * basept = dest->base;
    GLint outwidth = dest->width;
    GLint outheight = dest->height;
    GLint outpitch = dest->pitch;
    if (a) {} // unused

    if (xoffset + width > outwidth) return;
    if (yoffset + height > outheight) return;

    for (int y = yoffset; y < yoffset+height; y++)
    {
         GLubyte * outptr = basept + y * outpitch + xoffset * 3;
         for (int x = 0; x < width; x++)
         {
             *outptr++ = b;
             *outptr++ = g;
             *outptr++ = r;
         }
    }
}

