/* Summary: fillbuffer_rgb16.c
 * Fills solid blocks in a R5G6B5 buffer
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <stdlib.h>
#include <swgl/gltexture.h>
#include <swgl/glbuffer.h>

void _gl_fillbuffer_b8g8r8a8(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest)
{
    GLubyte * basept = dest->base;
    GLint outwidth = dest->width;
    GLint outheight = dest->height;
    GLint outpitch = dest->pitch;

    if (xoffset + width > outwidth) return;
    if (yoffset + height > outheight) return;

    GLuint col = b | (g << 8) | (r << 16) | (a << 24);

    for (int y = yoffset; y < yoffset+height; y++)
    {
         GLuint * outptr = (GLuint *) (basept + y * outpitch + xoffset * 4);
         for (int x = 0; x < width; x++)
             *outptr++ = col;
    }
}

