/* Summary: fillbuffer_i8.c
 * Fills solid blocks in a I8 buffer
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <stdlib.h>
#include <swgl/gltexture.h>
#include <swgl/glbuffer.h>

void _gl_fillbuffer_i8(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest)
{
    GLubyte * basept = dest->base;
    GLint outwidth = dest->width;
    GLint outheight = dest->height;
    GLint outpitch = dest->pitch;
    if (a) {} // unused

    if (xoffset + width > outwidth) return;
    if (yoffset + height > outheight) return;

    int tmpcol = ((int)r + (int)g + (int)b) / 3;
    GLubyte col = tmpcol;

    for (int y = yoffset; y < yoffset+height; y++)
    {
         GLubyte * outptr = (GLubyte *) (basept + y * outpitch + xoffset);
         for (int x = 0; x < width; x++)
             *outptr++ = col;
    }
}

