/* Summary: triflat.c
 * Flat triangle rendering
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <swgl/glpipe.h>
#include <swgl/glbuffer.h>

void _gl_flattriangle32(GLvertex * v1, GLvertex * v2, GLvertex * v3)
{
    int color = ((int) v3->cb) |
                ((int) v3->cg) << 8 |
                ((int) v3->cr) << 16 |
                ((int) v3->ca) << 24;

    GLint miny, maxy;
    GLint loopx, loopxmax, halfy, loopy, loopymax;
    GLint topx, topxadd, topxsub, topxstep;
    GLint botx, botxadd, botxsub, botxstep;

    GLint topxfrac, botxfrac;

    int temp;

    int x1 = v1->vx; int y1 = v1->vy;
    int x2 = v2->vx; int y2 = v2->vy;
    int x3 = v3->vx; int y3 = v3->vy;

    /* sort points in order. floating bubble sort
     ' y1 will become topmost, y3 bottommost, y2 in the middle
     ' this should fix a lot of code duplication later on*/
    if(y1 > y2)
    {
        temp = x1;
        x1 = x2;
        x2 = temp;
        temp = y1;
        y1 = y2;
        y2 = temp;
    }

    if (y2 > y3)
    {
        temp = x2;
        x2 = x3;
        x3 = temp;
        temp = y2;
        y2 = y3;
        y3 = temp;
    }

    if (y1 > y2)
    {
        temp = x1;
        x1 = x2;
        x2 = temp;
        temp = y1;
        y1 = y2;
        y2 = temp;
    }

    miny = y1;
    maxy = y3;
    halfy = y2;
    if (miny < _gl_cutoff_n) miny = _gl_cutoff_n;
    if (halfy < _gl_cutoff_n) halfy = _gl_cutoff_n;
    if (halfy >= _gl_cutoff_s) halfy = _gl_cutoff_s - 1;
    if (maxy >= _gl_cutoff_s) maxy = _gl_cutoff_s - 1;

    // check if the triangle is visible
    if (maxy > miny)
    {
        botx = x1;
        botxstep = (x3-x1) / (y3-y1);
        botxadd = (x3-x1) % (y3-y1);
        botxsub = (y3-y1);
        botxfrac = 0;

        // if clamped north
        if (miny > y1)
        {
            botxfrac += botxadd * (miny-y1);
            botx += (miny - y1) * botxstep;
            if (botxfrac < 0)
            {
                botx -= (-botxfrac / botxsub);
                botxfrac = -(-botxfrac % botxsub);
            }
            else
            {
                botx += (botxfrac / botxsub);
                botxfrac %= botxsub;
            }
        }

        //'Split the triangle in two
        if (halfy > miny)
        {

            topx = x1;
            topxstep = (x2-x1) / (y2-y1);
            topxadd = (x2-x1) % (y2-y1);
            topxsub = (y2-y1);
            topxfrac = 0;

            // if clamped north
            if (miny > y1)
            {
                topxfrac += topxadd * (miny-y1);
                topx += (miny - y1) * topxstep;
                if (topxfrac < 0)
                {
                    topx -= (-topxfrac / topxsub);
                    topxfrac = -(-topxfrac % topxsub);
                }
                else
                {
                    topx += (topxfrac / topxsub);
                    topxfrac %= topxsub;
                }
            }

            loopy = miny;
            loopymax = halfy;
            //if (loopy < _gl_cutoff_n) loopy = _gl_cutoff_n;
            if (loopymax > _gl_cutoff_s) loopymax = _gl_cutoff_s;

            for( ; loopy < loopymax; loopy++)
            {

                GLint * rowpt = (GLint *) &(_gl_backbuffer->base[loopy * _gl_backbuffer->pitch]);

                if (topx <= botx)
                {
                    loopx = topx;
                    loopxmax = botx;
                    if (loopx < _gl_cutoff_w) loopx = _gl_cutoff_w;
                    if (loopxmax > _gl_cutoff_e) loopxmax = _gl_cutoff_e;

                    for ( ; loopx < loopxmax; loopx++)
                        rowpt[loopx] = color;


                } else {

                    loopx = botx;
                    loopxmax = topx;
                    if (loopx < _gl_cutoff_w) loopx = _gl_cutoff_w;
                    if (loopxmax > _gl_cutoff_e) loopxmax = _gl_cutoff_e;


                    for ( ; loopx < loopxmax; loopx++)
                        rowpt[loopx] = color;

                }

                topx = topx + topxstep;
                topxfrac = topxfrac + topxadd;
                if (topxfrac > topxsub)
                {
                    topxfrac = topxfrac - topxsub;
                    topx = topx + 1;
                }
                if (topxfrac < -topxsub)
                {
                    topxfrac = topxfrac + topxsub;
                    topx = topx - 1;
                }

                botx = botx + botxstep;
                botxfrac = botxfrac + botxadd;
                if (botxfrac > botxsub)
                {
                    botxfrac = botxfrac - botxsub;
                    botx = botx + 1;
                }
                if (botxfrac < -botxsub)
                {
                    botxfrac = botxfrac + botxsub;
                    botx = botx - 1;
                }

            }
        }

        if (halfy < maxy)
        {

            topx = x2;
            topxstep = (x3-x2) / (y3-y2);
            topxadd = (x3-x2) % (y3-y2);
            topxsub = (y3-y2);
            topxfrac = 0;

            // if clamped north
            if (halfy > y2)
            {
                topxfrac += topxadd * (halfy-y2);
                topx += (halfy - y2) * topxstep;
                if (topxfrac < 0)
                {
                    topx -= (-topxfrac / topxsub);
                    topxfrac = -(-topxfrac % topxsub);
                }
                else
                {
                    topx += (topxfrac / topxsub);
                    topxfrac %= topxsub;
                }
            }

            loopy = halfy;
            loopymax = maxy;
            if (loopy < _gl_cutoff_n) loopy = _gl_cutoff_n;
            if (loopymax > _gl_cutoff_s) loopymax = _gl_cutoff_s;

            for ( ; loopy < maxy; loopy++)
            {
                GLint * rowpt = (GLint *) &(_gl_backbuffer->base[loopy * _gl_backbuffer->pitch]);

                if (topx <= botx)
                {
                    loopx = topx;
                    loopxmax = botx;
                    if (loopx < _gl_cutoff_w) loopx = _gl_cutoff_w;
                    if (loopxmax > _gl_cutoff_e) loopxmax = _gl_cutoff_e;

                    for ( ; loopx < loopxmax; loopx++)
                        rowpt[loopx] = color;

                } else {

                    loopx = botx;
                    loopxmax = topx;
                    if (loopx < _gl_cutoff_w) loopx = _gl_cutoff_w;
                    if (loopxmax > _gl_cutoff_e) loopxmax = _gl_cutoff_e;


                    for ( ; loopx < loopxmax; loopx++)
                        rowpt[loopx] = color;

                }

                topx = topx + topxstep;
                topxfrac = topxfrac + topxadd;
                if (topxfrac > topxsub)
                {
                    topxfrac = topxfrac - topxsub;
                    topx = topx + 1;
                }
                if (topxfrac < -topxsub)
                {
                    topxfrac = topxfrac + topxsub;
                    topx = topx - 1;
                }

                botx = botx + botxstep;
                botxfrac = botxfrac + botxadd;
                if (botxfrac > botxsub)
                {
                    botxfrac = botxfrac - botxsub;
                    botx = botx + 1;
                }
                if (botxfrac < -botxsub)
                {
                    botxfrac = botxfrac + botxsub;
                    botx = botx - 1;
                }
            }
        }
    }
}
