/* Summary: trigoraud.c
 * Goraud shaded triangle rendering
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <swgl/glpipe.h>
#include <swgl/glbuffer.h>

void _gl_goraudtriangle32(GLvertex * v1, GLvertex * v2, GLvertex * v3)
{
    /*int color = ((int) v3->cb) |
                ((int) v3->cg) << 8 |
                ((int) v3->cr) << 16 |
                ((int) v3->ca) << 24;*/

    GLint miny, maxy;
    GLint loopx, loopxmax, halfy, loopy;
    GLint topx, topxadd, topxsub, topxstep;
    GLint botx, botxadd, botxsub, botxstep;

    GLint topxfrac, botxfrac;

    GLvertex *o1, *o2, *o3, *tempv;

    /* sort points in order. floating bubble sort
     ' y1 will become topmost, y3 bottommost, y2 in the middle
     ' this should fix a lot of code duplication later on*/
    o1 = v1;
    o2 = v2;
    o3 = v3;
    if (o1->vy > o2->vy)
    {
        tempv = o1;
        o1 = o2;
        o2 = tempv;
    }
    if (o2->vy > o3->vy)
    {
        tempv = o2;
        o2 = o3;
        o3 = tempv;
    }
    if (o1->vy > o2->vy)
    {
        tempv = o1;
        o1 = o2;
        o2 = tempv;
    }

    int x1 = o1->vx; int y1 = o1->vy;
    int x2 = o2->vx; int y2 = o2->vy;
    int x3 = o3->vx; int y3 = o3->vy;

    int c1[4];
    int c2[4];
    int c3[4];

    c1[0] = o1->cr; c1[1] = o1->cg; c1[2] = o1->cb; //int a1 = o1->ca;
    c2[0] = o2->cr; c2[1] = o2->cg; c2[2] = o2->cb; //int a2 = o2->ca;
    c3[0] = o3->cr; c3[1] = o3->cg; c3[2] = o3->cb; //int a3 = o3->ca;

    int botc[4], botcadd[4], botcstep[4], botcfrac[4];
    int c;
    int topc[4], topcadd[4], topcstep[4], topcfrac[4];
    GLubyte rowc[4];
    int rowcadd[4], rowcstep[4], rowcfrac[4], rowcsub[4], rowcsign[4];

    miny = y1;
    maxy = y3;
    halfy = y2;
    if (miny < _gl_cutoff_n) miny = _gl_cutoff_n;
    if (halfy < _gl_cutoff_n) halfy = _gl_cutoff_n;
    if (halfy >= _gl_cutoff_s) halfy = _gl_cutoff_s - 1;
    if (maxy >= _gl_cutoff_s) maxy = _gl_cutoff_s - 1;

    // check if the triangle is visible
    if (maxy > miny)
    {
        botx = x1;
        botxstep = (x3-x1) / (y3-y1);
        botxadd = (x3-x1) % (y3-y1);
        botxsub = (y3-y1);
        botxfrac = 0;

        for (c = 0; c < 4; c++)
        {
            botc[c] = c1[c];
            botcstep[c] = (c3[c]-c1[c]) / (y3-y1);
            botcadd[c] = (c3[c]-c1[c]) % (y3-y1);
            botcfrac[c] = botcadd[c] >> 1;
        }

        // if clamped north
        if (miny > y1)
        {
            botxfrac += botxadd * (miny-y1);
            botx += (miny - y1) * botxstep;
            if (botxfrac < 0)
            {
                botx -= (-botxfrac / botxsub);
                botxfrac = -(-botxfrac % botxsub);
            }
            else
            {
                botx += (botxfrac / botxsub);
                botxfrac %= botxsub;
            }
            
            for (c = 0; c < 4; c++)
            {
                botcfrac[c] += botcadd[c] * (miny-y1);
                botc[c] += botcstep[c] * (miny - y1);
                botc[c] += botcfrac[c] / botxsub;
                botcfrac[c] %= botxsub;
            }
        }


        //'Split the triangle in two
        if (halfy > miny)
        {

            topx = x1;
            topxstep = (x2-x1) / (y2-y1);
            topxadd = (x2-x1) % (y2-y1);
            topxsub = (y2-y1);
            topxfrac = 0;
            
            for (c = 0; c < 4; c++)
            {
                topc[c] = c1[c];
                topcstep[c] = (c2[c]-c1[c]) / (y2-y1);
                topcadd[c] = (c2[c]-c1[c]) % (y2-y1);
                topcfrac[c] = topcadd[c] >> 1;
            }

            // if clamped north
            if (miny > y1)
            {
                topxfrac += topxadd * (miny-y1);
                topx += (miny - y1) * topxstep;
                if (topxfrac < 0)
                {
                    topx -= (-topxfrac / topxsub);
                    topxfrac = -(-topxfrac % topxsub);
                }
                else
                {
                    topx += (topxfrac / topxsub);
                    topxfrac %= topxsub;
                }

                for (c = 0; c < 4; c++)
                {
                    topcfrac[c] += topcadd[c] * (miny-y1);
                    topc[c] += topcstep[c] * (miny - y1);
                    topc[c] += topcfrac[c] / topxsub;
                    topcfrac[c] %= topxsub;
                }
            }

            for(loopy = miny; loopy < halfy; loopy++)
            {

                GLint * rowpt = (GLint *) &(_gl_backbuffer->base[loopy * _gl_backbuffer->pitch]);

                if (topx < botx)
                {
                    loopx = topx;
                    loopxmax = botx;
                    if (loopx < _gl_cutoff_w) loopx = _gl_cutoff_w;
                    if (loopxmax > _gl_cutoff_e) loopxmax = _gl_cutoff_e;

                    for (c = 0; c < 4; c++)
                    {
                        rowc[c] = topc[c];
                        rowcstep[c] = (botc[c]-topc[c]) / (loopxmax-loopx);
                        rowcadd[c] = (botc[c]-topc[c]) % (loopxmax-loopx);
                        rowcsign[c] = (rowcadd[c] > 0) ? 1 : -1;
                        rowcadd[c] = (rowcadd[c] > 0) ? rowcadd[c] : -rowcadd[c];
                        rowcsub[c] = (loopxmax-loopx);
                        rowcfrac[c] = rowcadd[c] >> 1;
                    }

                    for ( ; loopx < loopxmax; loopx++)
                    {
                        rowpt[loopx] = rowc[0] << 16 | rowc[1] << 8 | rowc[2];

                        for (c = 0; c < 4; c++)
                        {
                            rowc[c] += rowcstep[c];
                            rowcfrac[c] += rowcadd[c];
                            if (rowcfrac[c] > rowcsub[c])
                            {
                                rowcfrac[c] -= rowcsub[c];
                                rowc[c] += rowcsign[c];
                            }
                        }
                    }

                } else if (topx > botx) {

                    loopx = botx;
                    loopxmax = topx;
                    if (loopx < _gl_cutoff_w) loopx = _gl_cutoff_w;
                    if (loopxmax > _gl_cutoff_e) loopxmax = _gl_cutoff_e;

                    for (c = 0; c < 4; c++)
                    {
                        rowc[c] = botc[c];
                        rowcstep[c] = (topc[c]-botc[c]) / (loopxmax-loopx);
                        rowcadd[c] = (topc[c]-botc[c]) % (loopxmax-loopx);
                        rowcsign[c] = (rowcadd[c] > 0) ? 1 : -1;
                        rowcadd[c] = (rowcadd[c] > 0) ? rowcadd[c] : -rowcadd[c];
                        rowcsub[c] = (loopxmax-loopx);
                        rowcfrac[c] = rowcadd[c] >> 1;
                    }

                    for ( ; loopx < loopxmax; loopx++)
                    {
                        rowpt[loopx] = rowc[0] << 16 | rowc[1] << 8 | rowc[2];

                        for (c = 0; c < 4; c++)
                        {
                            rowc[c] += rowcstep[c];
                            rowcfrac[c] += rowcadd[c];
                            if (rowcfrac[c] > rowcsub[c])
                            {
                                rowcfrac[c] -= rowcsub[c];
                                rowc[c] += rowcsign[c];
                            }
                        }
                    }

                }

                topx = topx + topxstep;
                topxfrac = topxfrac + topxadd;
                if (topxfrac > topxsub)
                {
                    topxfrac = topxfrac - topxsub;
                    topx = topx + 1;
                }
                if (topxfrac < -topxsub)
                {
                    topxfrac = topxfrac + topxsub;
                    topx = topx - 1;
                }

                botx = botx + botxstep;
                botxfrac = botxfrac + botxadd;
                if (botxfrac > botxsub)
                {
                    botxfrac = botxfrac - botxsub;
                    botx = botx + 1;
                }
                if (botxfrac < -botxsub)
                {
                    botxfrac = botxfrac + botxsub;
                    botx = botx - 1;
                }

                for (c = 0; c < 4; c++)
                {
                    botc[c] = botc[c] + botcstep[c];
                    botcfrac[c] = botcfrac[c] + botcadd[c];
                    if (botcfrac[c] > botxsub)
                    {
                        botcfrac[c] -= botxsub;
                        botc[c]++;
                    }
                    if (botcfrac[c] < -botxsub)
                    {
                        botcfrac[c] += botxsub;
                        botc[c]--;
                    }

                    topc[c] = topc[c] + topcstep[c];
                    topcfrac[c] = topcfrac[c] + topcadd[c];
                    if (topcfrac[c] > topxsub)
                    {
                        topcfrac[c] -= topxsub;
                        topc[c]++;
                    }
                    if (topcfrac[c] < -topxsub)
                    {
                        topcfrac[c] += topxsub;
                        topc[c]--;
                    }
                }

            }
        }


        if (halfy < maxy)
        {

            topx = x2;
            topxstep = (x3-x2) / (y3-y2);
            topxadd = (x3-x2) % (y3-y2);
            topxsub = (y3-y2);
            topxfrac = 0;
            
            for (c = 0; c < 4; c++)
            {
                topc[c] = c2[c];
                topcstep[c] = (c3[c]-c2[c]) / (y3-y2);
                topcadd[c] = (c3[c]-c2[c]) % (y3-y2);
                topcfrac[c] = topcadd[c] >> 1;
            }

            // if clamped north
            if (halfy > y2)
            {
                topxfrac += topxadd * (halfy-y2);
                topx += (halfy - y2) * topxstep;
                if (topxfrac < 0)
                {
                    topx -= (-topxfrac / topxsub);
                    topxfrac = -(-topxfrac % topxsub);
                }
                else
                {
                    topx += (topxfrac / topxsub);
                    topxfrac %= topxsub;
                }
                
                for (c = 0; c < 4; c++)
                {
                    topcfrac[c] += topcadd[c] * (miny-y1);
                    topc[c] += topcstep[c] * (miny - y1);
                    topc[c] += topcfrac[c] / topxsub;
                    topcfrac[c] %= topxsub;
                }
            }

            for (loopy = halfy; loopy < maxy; loopy++)
            {
                GLint * rowpt = (GLint *) &(_gl_backbuffer->base[loopy * _gl_backbuffer->pitch]);

                if (topx < botx)
                {
                    loopx = topx;
                    loopxmax = botx;
                    if (loopx < _gl_cutoff_w) loopx = _gl_cutoff_w;
                    if (loopxmax > _gl_cutoff_e) loopxmax = _gl_cutoff_e;

                    for (c = 0; c < 4; c++)
                    {
                        rowc[c] = topc[c];
                        rowcstep[c] = (botc[c]-topc[c]) / (loopxmax-loopx);
                        rowcadd[c] = (botc[c]-topc[c]) % (loopxmax-loopx);
                        rowcsign[c] = (rowcadd[c] > 0) ? 1 : -1;
                        rowcadd[c] = (rowcadd[c] > 0) ? rowcadd[c] : -rowcadd[c];
                        rowcsub[c] = (loopxmax-loopx);
                        rowcfrac[c] = rowcadd[c] >> 1;
                    }

                    for ( ; loopx < loopxmax; loopx++)
                    {
                        rowpt[loopx] = rowc[0] << 16 | rowc[1] << 8 | rowc[2];

                        for (c = 0; c < 4; c++)
                        {
                            rowc[c] += rowcstep[c];
                            rowcfrac[c] += rowcadd[c];
                            if (rowcfrac[c] > rowcsub[c])
                            {
                                rowcfrac[c] -= rowcsub[c];
                                rowc[c] += rowcsign[c];
                            }
                        }
                    }

                } else if (topx > botx) {

                    loopx = botx;
                    loopxmax = topx;
                    if (loopx < _gl_cutoff_w) loopx = _gl_cutoff_w;
                    if (loopxmax > _gl_cutoff_e) loopxmax = _gl_cutoff_e;

                    for (c = 0; c < 4; c++)
                    {
                        rowc[c] = botc[c];
                        rowcstep[c] = (topc[c]-botc[c]) / (loopxmax-loopx);
                        rowcadd[c] = (topc[c]-botc[c]) % (loopxmax-loopx);
                        rowcsign[c] = (rowcadd[c] > 0) ? 1 : -1;
                        rowcadd[c] = (rowcadd[c] > 0) ? rowcadd[c] : -rowcadd[c];
                        rowcsub[c] = (loopxmax-loopx);
                        rowcfrac[c] = rowcadd[c] >> 1;
                    }

                    for ( ; loopx < loopxmax; loopx++)
                    {
                        rowpt[loopx] = rowc[0] << 16 | rowc[1] << 8 | rowc[2];

                        for (c = 0; c < 4; c++)
                        {
                            rowc[c] += rowcstep[c];
                            rowcfrac[c] += rowcadd[c];
                            if (rowcfrac[c] > rowcsub[c])
                            {
                                rowcfrac[c] -= rowcsub[c];
                                rowc[c] += rowcsign[c];
                            }
                        }
                    }

                }

                topx = topx + topxstep;
                topxfrac = topxfrac + topxadd;
                if (topxfrac > topxsub)
                {
                    topxfrac = topxfrac - topxsub;
                    topx = topx + 1;
                }
                if (topxfrac < -topxsub)
                {
                    topxfrac = topxfrac + topxsub;
                    topx = topx - 1;
                }

                botx = botx + botxstep;
                botxfrac = botxfrac + botxadd;
                if (botxfrac > botxsub)
                {
                    botxfrac = botxfrac - botxsub;
                    botx = botx + 1;
                }
                if (botxfrac < -botxsub)
                {
                    botxfrac = botxfrac + botxsub;
                    botx = botx - 1;
                }

                for (c = 0; c < 4; c++)
                {
                    botc[c] = botc[c] + botcstep[c];
                    botcfrac[c] = botcfrac[c] + botcadd[c];
                    if (botcfrac[c] > botxsub)
                    {
                        botcfrac[c] -= botxsub;
                        botc[c]++;
                    }
                    if (botcfrac[c] < -botxsub)
                    {
                        botcfrac[c] += botxsub;
                        botc[c]--;
                    }

                    topc[c] = topc[c] + topcstep[c];
                    topcfrac[c] = topcfrac[c] + topcadd[c];
                    if (topcfrac[c] > topxsub)
                    {
                        topcfrac[c] -= topxsub;
                        topc[c]++;
                    }
                    if (topcfrac[c] < -topxsub)
                    {
                        topcfrac[c] += topxsub;
                        topc[c]--;
                    }
                }
            }
        }
    }
}
