; Summary: trigoraud_mmx.asm
; Goraud shaded triangle rendering, using the MMX extensions
;
; Author:
;     Marcel Sondaar
;
; License:
;     <Public Domain>
;

bits 32
section .text
cpu 586 mmx
global _gl_goraudtriangle32_mmx

extern _gl_cutoff_n
extern _gl_cutoff_e
extern _gl_cutoff_s
extern _gl_cutoff_w



_gl_goraudtriangle32_mmx:   PUSH EBP                        ; save callee-saved registers
                            PUSH EBX                        ; save callee-saved registers
                            PUSH ESI                        ; save callee-saved registers
                            PUSH EDI                        ; save callee-saved registers

                            ; stack: ESP->EDI, ESI, EBX, EBP, EIP, (+20) vertex1, (+24)vertex2, (+28)vertex3
                            MOV EBP, ESP
                            SUB ESP, 36
                            ; ESP (-4)y1 (-8)y2 (-12)y3

                            MOV EAX, [EBP+20]
                            MOV EBX, [EBP+24]
                            FLD [EAX+4]                     ; v1.y
                            MOV ECX, [EBP+28]
                            FLD [EBX+4]                     ; v2.y
                            FXCH st(1)
                            FISTP dword [ESP-4]
                            FLD [ECX+4]                     ; v3.y
                            FXCH st(1)
                            FISTP dword [EBP-8]
                            MOV ESI, [EBP-4]                ; esi = y1
                            FISTP dword [EBP-12]
                            MOV EDI, [EBP-8]                ; edi = y2
                            CMP ESI, [EBP-8]                ; y1 ? y2
                            MOV EDX, [EBP-12]               ; edx = y3
                            JAE .v1belowv2
.v2belowv1:                 CMP ESI, [EBP-12]               ; y1 < y2; y1 ? y3
                            JLE order312
                            CMP EDI, EDX                    ; y2 ? y3
                            JLE .order132
.order123:                  MOV [EBP-8], ESI
                            FLD [EAX]
                            MOV [EBP-16], EDI
                            FLD [EBX]
                            MOV [EBP-24], EDX
                            FLD [ECX]
                            MOV ESI, [EAX+32]
                            MOV EDI, [EBX+32]
                            MOV EDX, [ECX+32]
                            JMP .cont
.v1belowv2:                 CMP EDI, [EBP-12]               ; y2 < y1; y2 ? y3
                            JLE .order321
                            CMP ESI, EDX                    ; y1 ? y3
                            JLE .order231
.order213:                  FLD [EBX]
                            MOV [EBP-16], ESI
                            FLD [EAX]
                            MOV [EBP-24], EDX
                            FLD [ECX]
                            MOV ESI, [EBX+32]
                            MOV EDI, [EAX+32]
                            MOV EDX, [ECX+32]
                            JMP .cont
.order132:                  MOV [EBP-8], ESI
                            FLD [EAX]
                            MOV [EBP-16], EDX
                            FLD [ECX]
                            MOV [EBP-24], EDI
                            FLD [EBX]
                            MOV ESI, [EAX+32]
                            MOV EDI, [ECX+32]
                            MOV EDX, [EBX+32]
                            JMP .cont
.order312:                  MOV [EBP-8], EDX
                            FLD [ECX]
                            MOV [EBP-16], ESI
                            FLD [EAX]
                            MOV [EBP-24], EDI
                            FLD [EBX]
                            MOV ESI, [ECX+32]
                            MOV EDI, [EAX+32]
                            MOV EDX, [EBX+32]
                            JMP .cont
.order231:                  FLD [EBX]
                            MOV [EBP-16], EDX
                            FLD [ECX]
                            MOV [EBP-24], ESI
                            FLD [EAX]
                            MOV ESI, [EBX+32]
                            MOV EDI, [ECX+32]
                            MOV EDX, [EAX+32]
                            JMP .cont
.order321:                  MOV [EBP-8], EDX
                            FLD [ECX]
                            MOV [EBP-28], ECX
                            FLD [EAX]
                            MOV [EBP-32], EAX
                            FLD [EBX]
                            MOV ESI, [ECX+32]
                            MOV EDI, [EAX+32]
                            MOV EDX, [EBX+32]

                            ;st(0) = bot.x
                            ;st(1) = mid.x
                            ;st(2) = top.x
                            ;ebp  -4   -8   -12  -16  -20  -24  -28  -32  -36
                            ;     t.x  t.y  m.x  m.y  b.x  b.y  t.c  m.c  b.c
                            ;ESI = t.c EDI = m.c EDX = b.c
.cont:                      FISTP dword [EBP-20]
                            MOV EAX, [EBP-8]
                            FISTP dword [EBP-12]
                            MOV ECX, [EBP-24]
                            FISTP dword [EBP-4]
                            CMP ECX, [_gl_cutoff_n]







                            EMMS
                            POP EDI
                            POP ESI
                            POP EBX
                            POP EBP
                            RET
