/* Summary: tritex.c
 * Textured triangle rendering
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <swgl/glpipe.h>
#include <swgl/glbuffer.h>
#include <swgl/gltexture.h>

void _gl_textriangle32(GLvertex * vx1, GLvertex * vx2, GLvertex * vx3)
{
    /*int color = ((int) vx3->cb) |
                ((int) vx3->cg) << 8 |
                ((int) vx3->cr) << 16 |
                ((int) vx3->ca) << 24;*/

    GLint miny, maxy;
    GLint loopx, halfy, loopy;
    GLint topx, topxadd, topxsub, topxstep;
    GLint botx, botxadd, botxsub, botxstep;

    GLint topxfrac, botxfrac;

    //int temp;

    GLvertex *o1, *o2, *o3, *tempv;

    /* sort points in order. floating bubble sort
     ' y1 will become topmost, y3 bottommost, y2 in the middle
     ' this should fix a lot of code duplication later on*/
    o1 = vx1;
    o2 = vx2;
    o3 = vx3;
    if (o1->vy > o2->vy)
    {
        tempv = o1;
        o1 = o2;
        o2 = tempv;
    }
    if (o2->vy > o3->vy)
    {
        tempv = o2;
        o2 = o3;
        o3 = tempv;
    }
    if (o1->vy > o2->vy)
    {
        tempv = o1;
        o1 = o2;
        o2 = tempv;
    }

    int x1 = o1->vx; int y1 = o1->vy;
    int x2 = o2->vx; int y2 = o2->vy;
    int x3 = o3->vx; int y3 = o3->vy;

    float u1 = o1->tu; float v1 = o1->tv;
    float u2 = o2->tu; float v2 = o2->tv;
    float u3 = o3->tu; float v3 = o3->tv;

    miny = y1;
    maxy = y3;
    halfy = y2;
    if (miny < 0) miny = 0;
    if (maxy >= _gl_backbuffer->height) maxy = _gl_backbuffer->height - 1;

    float botu, botv, botustep, botvstep;
    float topu, topv, topustep, topvstep;

    GLint botufix, botvfix, botufixstep, botvfixstep;
    GLint topufix, topvfix, topufixstep, topvfixstep;

    GLint rowdu, rowdv, rowu, rowv;
    GLint rowustep, rowvstep, rowuadd, rowvadd, rowsub;

    int ushift, vshift, umask, vmask;
    int * texdata = (int *) (_gl_currenttexture->texture.base);

    ushift = _gl_currenttexture->ubits;
    vshift = _gl_currenttexture->vbits;

    umask = _gl_currenttexture->texture.width - 1;
    vmask = _gl_currenttexture->texture.height - 1;
    vmask <<= ushift;
    vshift += ushift;

    ushift = 16 - ushift;
    vshift = 16 - vshift;

    // check if the triangle is visible
    if (maxy > miny)
    {
        botx = x1;
        botxstep = (x3-x1) / (y3-y1);
        botxadd = (x3-x1) % (y3-y1);
        botxsub = (y3-y1);
        botxfrac = 0;

        botu = u1;
        botv = v1;
        botustep = (u3-u1) / (y3-y1);
        botvstep = (v3-v1) / (y3-y1);

        botufix = (int)(botu * 65536.0f);
        botvfix = (int)(botv * 65536.0f);
        botufixstep = (int)(botustep * 65536.0f);
        botvfixstep = (int)(botvstep * 65536.0f);


        //'Split the triangle in two
        if (halfy > miny)
        {

            topx = x1;
            topxstep = (x2-x1) / (y2-y1);
            topxadd = (x2-x1) % (y2-y1);
            topxsub = (y2-y1);
            topxfrac = 0;

            topu = u1;
            topv = v1;
            topustep = (u2-u1) / (y2-y1);
            topvstep = (v2-v1) / (y2-y1);

            topufix = (int)(topu * 65536.0f);
            topvfix = (int)(topv * 65536.0f);
            topufixstep = (int)(topustep * 65536.0f);
            topvfixstep = (int)(topvstep * 65536.0f);

            for(loopy = miny; loopy < halfy; loopy++)
            {

                GLint * rowpt = (GLint *) &(_gl_backbuffer->base[loopy * _gl_backbuffer->pitch]);

                if (topx < botx)
                {
                    rowdu = botufix - topufix;
                    rowdv = botvfix - topvfix;
                    rowu = topufix;
                    rowv = topvfix;
                    rowsub = botx-topx;
                    rowustep = rowdu / rowsub;
                    rowuadd =  rowdu % rowsub;
                    rowvstep = rowdv / rowsub;
                    rowvadd =  rowdv % rowsub;

                    for (loopx = topx; loopx < botx; loopx++)
                    {
                        rowpt[loopx] = texdata[((rowu >> ushift) & umask) | ((rowv >> vshift) & vmask)];

                        rowu += rowustep;
                        rowv += rowvstep;
                    }

                } else if (botx < topx) {

                    rowdu = topufix - botufix;
                    rowdv = topvfix - botvfix;
                    rowu = botufix;
                    rowv = botvfix;
                    rowsub = topx-botx;
                    rowustep = rowdu / rowsub;
                    rowuadd =  rowdu % rowsub;
                    rowvstep = rowdv / rowsub;
                    rowvadd =  rowdv % rowsub;

                    for (loopx = botx; loopx < topx; loopx++)
                    {
                        rowpt[loopx] = texdata[((rowu >> ushift) & umask) | ((rowv >> vshift) & vmask)];

                        rowu += rowustep;
                        rowv += rowvstep;
                    }

                }

                topx = topx + topxstep;
                topxfrac = topxfrac + topxadd;
                if (topxfrac > topxsub)
                {
                    topxfrac = topxfrac - topxsub;
                    topx = topx + 1;
                }
                if (topxfrac < -topxsub)
                {
                    topxfrac = topxfrac + topxsub;
                    topx = topx - 1;
                }

                botx = botx + botxstep;
                botxfrac = botxfrac + botxadd;
                if (botxfrac > botxsub)
                {
                    botxfrac = botxfrac - botxsub;
                    botx = botx + 1;
                }
                if (botxfrac < -botxsub)
                {
                    botxfrac = botxfrac + botxsub;
                    botx = botx - 1;
                }

                topufix += topufixstep;
                topvfix += topvfixstep;
                botufix += botufixstep;
                botvfix += botvfixstep;
            }
        }

        if (halfy < maxy)
        {

            topx = x2;
            topxstep = (x3-x2) / (y3-y2);
            topxadd = (x3-x2) % (y3-y2);
            topxsub = (y3-y2);
            topxfrac = 0;

            topu = u2;
            topv = v2;
            topustep = (u3-u2) / (y3-y2);
            topvstep = (v3-v2) / (y3-y2);

            topufix = (int)(topu * 65536.0f);
            topvfix = (int)(topv * 65536.0f);
            topufixstep = (int)(topustep * 65536.0f);
            topvfixstep = (int)(topvstep * 65536.0f);

            for (loopy = halfy; loopy < maxy; loopy++)
            {
                GLint * rowpt = (GLint *) &(_gl_backbuffer->base[loopy * _gl_backbuffer->pitch]);

                if (topx < botx)
                {
                    rowdu = botufix - topufix;
                    rowdv = botvfix - topvfix;
                    rowu = topufix;
                    rowv = topvfix;
                    rowsub = botx-topx;
                    rowustep = rowdu / rowsub;
                    rowuadd =  rowdu % rowsub;
                    rowvstep = rowdv / rowsub;
                    rowvadd =  rowdv % rowsub;

                    for (loopx = topx; loopx < botx; loopx++)
                    {
                        rowpt[loopx] = texdata[((rowu >> ushift) & umask) | ((rowv >> vshift) & vmask)];

                        rowu += rowustep;
                        rowv += rowvstep;
                    }

                } else if (botx < topx) {
                    
                    rowdu = topufix - botufix;
                    rowdv = topvfix - botvfix;
                    rowu = botufix;
                    rowv = botvfix;
                    rowsub = topx-botx;
                    rowustep = rowdu / rowsub;
                    rowuadd =  rowdu % rowsub;
                    rowvstep = rowdv / rowsub;
                    rowvadd =  rowdv % rowsub;

                    for (loopx = botx; loopx < topx; loopx++)
                    {
                        rowpt[loopx] = texdata[((rowu >> ushift) & umask) | ((rowv >> vshift) & vmask)];

                        rowu += rowustep;
                        rowv += rowvstep;
                    }
                }

                topx = topx + topxstep;
                topxfrac = topxfrac + topxadd;
                if (topxfrac > topxsub)
                {
                    topxfrac = topxfrac - topxsub;
                    topx = topx + 1;
                }
                if (topxfrac < -topxsub)
                {
                    topxfrac = topxfrac + topxsub;
                    topx = topx - 1;
                }

                botx = botx + botxstep;
                botxfrac = botxfrac + botxadd;
                if (botxfrac > botxsub)
                {
                    botxfrac = botxfrac - botxsub;
                    botx = botx + 1;
                }
                if (botxfrac < -botxsub)
                {
                    botxfrac = botxfrac + botxsub;
                    botx = botx - 1;
                }

                topufix += topufixstep;
                topvfix += topvfixstep;
                botufix += botufixstep;
                botvfix += botvfixstep;
            }
        }
    }
}
