/* Summary: backbuffer.c
 * Defines the rasterizer output
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <swgl/glbuffer.h>
#include <GL/gl.h>

static GLbuffer _gl_outputbuffer = {(unsigned char*)0, 0, 0, 0, 0, _gl_fillbuffer_b8g8r8a8, _gl_writebuffer_b8g8r8x8};

GLbuffer * _gl_framebuffer = &_gl_outputbuffer;
GLbuffer * _gl_backbuffer = &_gl_outputbuffer;

GLbuffer * _gl_currentbuffer = &_gl_outputbuffer;

void _gl_setoutput(GLubyte * buffer, GLuint w, GLuint h, GLuint pitch)
{
    _gl_outputbuffer.base = buffer;
    _gl_outputbuffer.width = w;
    _gl_outputbuffer.height = h;
    _gl_outputbuffer.pitch = pitch;
    _gl_outputbuffer.stride = 4;

    _gl_cutoff_n = 0;
    _gl_cutoff_w = 0;
    _gl_cutoff_e = w;
    _gl_cutoff_s = h;

    glViewport(0,0,w,h);
    glScissor(0,0,w,h);
}
