/* Summary: matrix.c
 * Matrix management
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <swgl/glmatrix.h>

GLmatrix _gl_currentmatrix;
GLint _gl_matrixvalid = 0;

GLmatrix _gl_modelview_stack[32];
GLmatrix _gl_projection_stack[32];
GLmatrix _gl_texture_stack[32];
GLint _gl_modelview_top = 0;
GLint _gl_projection_top = 0;
GLint _gl_texture_top = 0;

GLmatrix * _gl_selectedmatrix = &(_gl_modelview_stack[0]);
GLint _gl_selectedstack_top = 0;

void _gl_reloadmatrix(void)
{
    _gl_matrixvalid = 1;
    
    int n;
    for (n = 0; n < 16; n++)
        _gl_currentmatrix.m[n] = _gl_viewportmatrix.m[n];
        //_gl_modelview_stack[_gl_modelview_top].m[n];

    _gl_matrixmultiply(&_gl_currentmatrix, &(_gl_projection_stack[_gl_projection_top]));
    _gl_matrixmultiply(&_gl_currentmatrix, &(_gl_modelview_stack[_gl_modelview_top]));

}

void _gl_matrixmultiply(GLmatrix * dst, GLmatrix * src)
{
    GLmatrix temp;

    int u, v, n;
    for (u = 0; u < 4; u++)
    {
        for (v = 0; v < 4; v++)
        {
            temp.m[(v<<2) + u] = 0;
            for (n = 0; n < 4; n++)
            {
                temp.m[(v<<2) + u] += src->m[(v<<2) + n] * dst->m[(n<<2) + u];
            }
        }
    }

    for (n = 0; n < 16; n++)
    {
        //temp.m[n] = dst->m[n];
        dst->m[n] = temp.m[n];
    }
}
