/* Summary: texture.c
 * Initializes texture rasterizing
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <swgl/gltexture.h>
#include <stdlib.h>

GLtexture * _gl_currenttexture = NULL;

void _gl_inittextures()
{
    GLtexture * texture = (GLtexture *) malloc(sizeof(GLtexture));
    texture->texture.width = 4;
    texture->texture.height = 2;
    texture->texture.pitch = 16;
    texture->texture.stride = 4;
    texture->texture.base = (GLubyte *) malloc(32);
    texture->ubits = 2;
    texture->vbits = 1;

    GLuint * tdata = (GLuint *)(texture->texture.base);
    tdata[0] = 0x00FF0000; tdata[1] = 0x00000080; tdata[2] = 0x00000080; tdata[3] = 0x00FF0000;
    tdata[4] = 0x00008000; tdata[5] = 0x00FF0000; tdata[6] = 0x00FF0000; tdata[7] = 0x00008000;

    _gl_currenttexture = texture;
}

void _gl_shutdowntextures()
{
    _gl_deletetexture(_gl_currenttexture);
}

void _gl_deletetexture(GLtexture * texture)
{
    if (texture == NULL) return;
    free(texture->texture.base);
    free(texture);
}
