/**
 * Summary: buf_alloc.c
 * Create a new empty buffer object
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <udi_env.h>
#include <stdlib.h>
#include <string.h>

udi_buf_t * _udi_buf_alloc(void)
{
    mos_buf_t * hiddenpart;
    udi_buf_t * dst_buf;

    hiddenpart = (mos_buf_t *) malloc(sizeof(mos_buf_t) + sizeof(udi_buf_t));
    dst_buf = (udi_buf_t *) (hiddenpart + 1);
    udi_assert(hiddenpart != NULL);

    // initialize new buffer
    dst_buf->buf_size = 0;
    hiddenpart->first = NULL;
    hiddenpart->last = NULL;
    hiddenpart->tags = NULL;
    hiddenpart->allocated = 0;

    return dst_buf;
}

