/**
 * Summary: buf_free.c
 * Free a logical buffer
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <udi_env.h>
#include <stdlib.h>

void udi_buf_free (udi_buf_t *buf)
{
    if (!buf) return;
    
    mos_buf_t * actualbuf = ((mos_buf_t *)buf) - 1;
    
    mos_buf_part_t * pointer = actualbuf->first;
    while (pointer)
    {
        mos_buf_part_t * copy = pointer;
        pointer = pointer->next;
        copy->data->refcount--;
        if (copy->data->refcount == 0) copy->data->free_op(copy->data);        
        free(copy);
    }
    
    free(actualbuf);
}
