/**
 * Summary: buf_write.c
 * Write to a logical buffer
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <udi_env.h>
#include <stdlib.h>
#include <string.h>

void udi_buf_write (udi_buf_write_call_t *callback, udi_cb_t *gcb, const void *src_mem, udi_size_t src_len, udi_buf_t *dst_buf, udi_size_t dst_off, udi_size_t dst_len, udi_buf_path_t path_handle)
{
    if (path_handle) {} // TODO: add functionality
    
    mos_buf_t * hiddenpart = NULL;
    
    // output buffer
    if (!dst_buf)
    {
        hiddenpart = (mos_buf_t *) malloc(sizeof(mos_buf_t) + sizeof(udi_buf_t));
        dst_buf = (udi_buf_t *) (hiddenpart + 1);
        udi_assert(hiddenpart != NULL);
        
        // initialize new buffer
        dst_buf->buf_size = 0;
        hiddenpart->first = NULL;
        hiddenpart->last = NULL;
        hiddenpart->tags = NULL;
        hiddenpart->allocated = 0;
    }
    else
    {
        hiddenpart = ((mos_buf_t *)dst_buf) - 1;
        udi_assert(hiddenpart != NULL);
    }    
    
    // new buffer component
    mos_buf_part_t * bufferpart = (mos_buf_part_t *) malloc(sizeof(mos_buf_part_t));
    bufferpart->size = src_len;
    
    mos_buf_impl_t * storage = NULL;
    udi_assert(bufferpart != NULL);
    
    if (src_mem)
    {
        mos_malloc_buf_impl_t * stdstorage = (mos_malloc_buf_impl_t *) malloc(sizeof(mos_malloc_buf_impl_t));            
        udi_assert(stdstorage != NULL);        
        stdstorage->data = (udi_ubit8_t *) malloc(src_len);
        udi_assert(stdstorage->data != NULL);
        stdstorage->buf.refcount = 1;
        stdstorage->buf.free_op = _udi_malloc_buf_free_op;
        stdstorage->buf.copy_op = _udi_malloc_buf_copy_op;
        stdstorage->buf.lock_op = _udi_malloc_buf_lock_op;
        stdstorage->buf.unlock_op = _udi_malloc_buf_unlock_op;
        memcpy(stdstorage->data, src_mem, src_len);
        storage = &(stdstorage->buf);
    }
    else
    {
        mos_buf_impl_t * nullstorage = (mos_buf_impl_t *) malloc(sizeof(mos_buf_impl_t));
        udi_assert(nullstorage != NULL);
        nullstorage->refcount = 1;
        nullstorage->free_op = &_udi_generic_buf_free_op;
        nullstorage->copy_op = NULL;
        nullstorage->lock_op = NULL;
        nullstorage->unlock_op = NULL;
        storage = nullstorage;
    }
    udi_assert(storage != NULL);
    
    bufferpart->data = storage;
    bufferpart->offset = 0;
    
    // fix buf length
    dst_buf->buf_size = dst_buf->buf_size + src_len - dst_len;
    if (dst_buf->buf_size < src_len + dst_off) dst_buf->buf_size = src_len + dst_off; // in case of gap at start

    if (hiddenpart->allocated < src_len + dst_off)
        hiddenpart->allocated = src_len + dst_off;
    else
        hiddenpart->allocated += src_len - dst_len;
    
    // inject buffer component
    _udi_buf_inject(hiddenpart, bufferpart, dst_off, dst_len);    
    
    callback(gcb, dst_buf);
}


#ifdef TEST
#include <test.h>

typedef struct test_bufpair
{
    mos_buf_t hidden;
    udi_buf_t public;
} test_bufpair_t;

int main(void)
{
    BEGIN_TESTS;
    
    TESTCASE ( NO_TESTDRIVER );
    
    return(TEST_RESULTS);
}

#endif
