/**
 * Summary: gen_copy.c
 * Generic data copy from a buffer segment by using the lock/unlock function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <udi_env.h>
#include <string.h>

void _udi_generic_buf_copy_op(mos_buf_impl_t * buf, void * dst, udi_size_t off, udi_size_t len)
{
    const void * src = buf->lock_op(buf, off, len);
    memcpy(dst, src, len);
    buf->unlock_op(buf, src);
}
