/**
 * Summary: libc_copy.c
 * Copy from a libc-managed buffer
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <udi_env.h>
#include <string.h>

void _udi_malloc_buf_copy_op(mos_buf_impl_t * buf, void * dst, udi_size_t off, udi_size_t len)
{
    mos_malloc_buf_impl_t * actualbuf = (mos_malloc_buf_impl_t *)buf;
    const void * src = (const void *) (actualbuf->data + off);
    memcpy(dst, src, len);
}

#ifdef TEST
#include <test.h>
#include <stdlib.h>

int main(void)
{
    BEGIN_TESTS;
    
    mos_malloc_buf_impl_t buf = {
        {1, NULL, NULL, NULL, NULL},
        "Testcase"};
    char dest[16];  
    
    memset(dest, 0, 16);
    _udi_malloc_buf_copy_op(&(buf.buf), dest, 0, 8);
    TESTCASE( memcmp(dest, "Testcase", 9) == 0);    
    
    memset(dest, 0, 16);
    _udi_malloc_buf_copy_op(&(buf.buf), dest, 0, 4);
    TESTCASE( memcmp(dest, "Test", 5) == 0);
    
    memset(dest, 0, 16);
    _udi_malloc_buf_copy_op(&(buf.buf), dest, 2, 4);
    TESTCASE( memcmp(dest, "stca", 5) == 0);
    
    memset(dest, 'a', 16);
    _udi_malloc_buf_copy_op(&(buf.buf), dest, 4, 4);
    TESTCASE( memcmp(dest, "caseaaaa", 8) == 0);
    
    TESTCASE( buf.buf.refcount == 1 );
    
    return(TEST_RESULTS);
}

#endif
