/**
 * Summary: libc_lock.c
 * Get a read pointer to a libc-managed buffer
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <udi_env.h>

const void * _udi_malloc_buf_lock_op(mos_buf_impl_t * buf, udi_size_t off, udi_size_t len)
{
    if (off) if (len) {} // not used, might qualify for an debugging assertion though
    
    mos_malloc_buf_impl_t * actualbuf = (mos_malloc_buf_impl_t *)buf;
    return (const void *) (actualbuf->data + off);
}

#ifdef TEST
#include <test.h>

int main(void)
{
    BEGIN_TESTS;
    
    mos_malloc_buf_impl_t buf = {
        {1, NULL, NULL, NULL, NULL},
        "Testcase"};
    
    TESTCASE( _udi_malloc_buf_lock_op(&(buf.buf), 0, 8) == buf.data );
    TESTCASE( _udi_malloc_buf_lock_op(&(buf.buf), 4, 4) == (buf.data + 4) );
    TESTCASE( buf.buf.refcount == 1 );
    return(TEST_RESULTS);
}

#endif
