/**
 * Summary: cb_alloc.c
 * Allocating a control block
 *
 * Author:
 *     Bogdan Barbu
 *
 * License:
 *     <Public Domain>
 */

#define UDI_VERSION 0x101

#include <stdlib.h>
#include <string.h>
#include <udi.h>
#include <udi_env.h>

void udi_cb_alloc(udi_cb_alloc_call_t * callback, udi_cb_t * gcb, udi_index_t cb_idx, udi_channel_t default_channel)
{
    mos_cb_t * cb = (mos_cb_t *)gcb - 1;
    mos_channel_t * chan = (mos_channel_t *)default_channel;
    mos_mei_cb_mold_t * mold = cb->region->driver->cb_mold[cb_idx];
    void * new_mem = memset(malloc(mold->size), 0, mold->size);

    // Sanity checks

    udi_assert(mold != NULL);
    if (chan == UDI_NULL_CHANNEL)
    {
        default_channel = gcb->channel;
        chan = (mos_channel_t *)default_channel;
    }
    udi_assert(cb->region->driver->cb_mold[cb_idx]->cb_idx == cb_idx);

    if (new_mem == NULL) {
        cb->op_idx = 0;
        cb->func = (mos_callback_t)callback;
        // FIXME: Work our marshalling area
        mos_alloc_queue(cb);
    } else {
        // FIXME: We got it but still need to add proper queing
    }
}
