/**
 * Summary: endian_swap.c
 * Byte swap multiple data items
 *
 * Author:
 *     Bogdan Barbu
 *
 * License:
 *     <Public Domain>
 */

#define UDI_VERSION 0x101
#include <udi.h>

void udi_endian_swap(const void * src, void * dst, udi_ubit8_t swap_size, udi_ubit8_t stride, udi_ubit8_t rep_count)
{
    udi_assert(!(swap_size & (swap_size - 1)));
    switch(swap_size) {
        case 1: return;
        case 2: {
            udi_ubit16_t *u16p = (udi_ubit16_t *)src;
            udi_ubit16_t *u16dp = (udi_ubit16_t *)dst;

            stride = stride >> 1;
            for (; rep_count > 0; --rep_count) {
                *u16dp = UDI_ENDIAN_SWAP_16(*u16p);
                u16p = &u16p[stride];
                u16dp = &u16dp[stride];
            }
            break;
        }
        case 4: {
            udi_ubit32_t *u32p = (udi_ubit32_t *)src;
            udi_ubit32_t *u32dp = (udi_ubit32_t *)dst;

            stride = stride >> 2;
            for (; rep_count > 0; --rep_count) {
                *u32p = UDI_ENDIAN_SWAP_32(*u32p);
                u32p = &u32p[stride];
                u32dp = &u32dp[stride];
            }
            break;
        }
        default:
            while (rep_count--) {
                udi_ubit8_t const *p = (udi_ubit8_t const *) src;
                udi_ubit8_t const *p2;
                udi_ubit8_t *pd = (udi_ubit8_t *) dst;
                udi_ubit8_t *p2d;

                p = p + stride * rep_count; p2 = p + swap_size;
                pd = pd + stride * rep_count; p2d = pd + swap_size;
                while (p != p2) {
                    udi_ubit8_t aux = *p++;

                    *pd++ = *--p2;
                    *--p2d = aux;
                }
            }
    }
}
