/**
 * Summary: buf_enter.c
 * Inject a new buffer inline into the environment
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <udi_env.h>
#include <udi.h>
#include <stdlib.h>
#include <string.h>

udi_buf_t * _udi_buf_enter(void * pointer, udi_size_t length)
{
    udi_buf_t * buf = _udi_buf_alloc();

    // malloc buffer
    mos_buf_part_t * bufferpart = (mos_buf_part_t *)malloc(sizeof(mos_buf_part_t));
    mos_malloc_buf_impl_t * stdstorage = (mos_malloc_buf_impl_t *) malloc(sizeof(mos_malloc_buf_impl_t));

    udi_assert(bufferpart != NULL);
    bufferpart->size = length;
    udi_assert(stdstorage != NULL);
    stdstorage->data = (udi_ubit8_t *) malloc(length);
    udi_assert(stdstorage->data != NULL);
    stdstorage->buf.refcount = 1;

    stdstorage->buf.free_op = _udi_malloc_buf_free_op;
    stdstorage->buf.copy_op = _udi_malloc_buf_copy_op;
    stdstorage->buf.lock_op = _udi_malloc_buf_lock_op;
    stdstorage->buf.unlock_op = _udi_malloc_buf_unlock_op;
    memcpy(stdstorage->data, pointer, length);
    mos_buf_impl_t * storage = &(stdstorage->buf);

    bufferpart->data = storage;
    bufferpart->offset = 0;

    mos_buf_t * hiddenpart = ((mos_buf_t *)buf) - 1;
    hiddenpart->allocated = length;

    _udi_buf_inject(hiddenpart, bufferpart, 0, length);

    return buf;
}

