/**
 * Summary: cb_enter.c
 * Inject a new cb into the environment
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#define UDI_VERSION 0x101

#include <udi_env.h>
#include <udi.h>
#include <stdlib.h>

udi_cb_t * _udi_cb_enter(mos_region_t * region, int cbsize)
{
    // allocate buffer
    int memsize = cbsize + sizeof(mos_cb_t);
    void * cb_buffer = malloc(memsize);
    if (!cb_buffer) return NULL;
    
    // split buffer
    mos_cb_t * privatepart = (mos_cb_t*)cb_buffer;
    udi_cb_t * publicpart = (udi_cb_t*)(privatepart+1);
    
    // FIXME: fill fields
    //privatepart->op_idx = ?; 
    privatepart->region = region;
    privatepart->func = NULL; // no callback scheduled
    //privatepart->allocm = ?;
    //privatepart->flags = ?;
    //privatepart->Old = ?;
    //privatepart->New = ?;
    //publicpart->channel = ?;
    publicpart->context = region->contextdata;
    publicpart->scratch = malloc(4096);
    //publicpart->initiator_context;
    //publicpart->origin;
    udi_assert(publicpart->scratch != NULL);
    
    return publicpart;
}
