' Summary: decode_bus.bas
' Decoder for bus driver calls
'
'  Author:
'      Marcel Sondaar
'
'  License:
'      Public Domain
'

#include "mos/udidecode.bi"
#include "mos/bridge.bi"
#include "udi.bi"

Type udi_channel_event_cb_t
    cb As udi_cb_t
    event As Unsigned Byte
    remotecb As udi_cb_t Ptr
    parent_ID As Unsigned Byte
    path_handles As Byte Ptr ' udi_buf_path_t *
End Type
Const UDI_CHANNEL_CLOSED = 0
Const UDI_CHANNEL_BOUND = 1
Const UDI_CHANNEL_OP_ABORTED = 2

type udi_bus_device_ops_t
    udi_channel_event_ind_op_t As Sub(ByVal cb as udi_channel_event_cb_t Ptr) '*channel_event_ind_op;
    udi_bus_bind_ack_op_t As Sub (ByVal bus_bind_cb As udi_cb_t Ptr, ByVal constraints As Unsigned Integer, ByVal preferred_endianness As Unsigned Byte, ByVal status As Integer) '*bus_bind_ack_op;
    udi_bus_unbind_ack_op_t As Byte Ptr '*bus_unbind_ack_op;
    udi_intr_attach_ack_op_t As Byte Ptr '*intr_attach_ack_op;
    udi_intr_detach_ack_op_t As Byte Ptr '*intr_detach_ack_op;
End Type

Sub udi_parse_bridge_message(ByVal Source As udi_cb_t Ptr, ByVal Length As Integer, ByVal Message As Byte Ptr, ByVal Customdata as Byte Ptr)
    Dim msgp As Integer Ptr
    Dim metaindex As Integer
    msgp = CPtr(Integer Ptr, message)
    metaindex = CInt(customdata)

    Dim prov As udi_bus_device_ops_t Ptr
    prov = CPtr(udi_bus_device_ops_t Ptr, udi_init_info.ops_init_list[metaindex - 1].ops_vector) ' ops indices are 1-based

    If length < 4 then *Cptr(Byte Ptr, &HDE0001) = 0

    Select case msgp[0]

        Case BRIDGECOMMAND_CONACK
            (*prov).udi_bus_bind_ack_op_t(source, 0, 0, UDI_OK)

        Case Else
            '*Cptr(Byte Ptr, &HDE0002) = 0
    End Select

End Sub

Function udi_decode_bridge alias "udi_decode_bridge" (ByVal index As Integer, ByVal basecb as udi_cb_t Ptr) As protodelegate
    Dim rv As Protodelegate

    rv.opcodebase = BRIDGECOMMANDBASE
    rv.customdata = CPtr(Byte Ptr, index)
    rv.decoder = @udi_parse_bridge_message

    Dim channelcb as udi_channel_event_cb_t
    channelcb.cb = *basecb
    channelcb.event = UDI_CHANNEL_BOUND
    channelcb.remotecb = basecb

    Dim prov As udi_bus_device_ops_t Ptr
    prov = CPtr(udi_bus_device_ops_t Ptr, udi_init_info.ops_init_list[index - 1].ops_vector) ' ops indices are 1-based

    (*prov).udi_channel_event_ind_op_t(@channelcb)

    Function = rv
End Function
