/* Summary: decode_fs_provider.c
 * Decoder for Filesystem calls
 *
 *  Author:
 *      Marcel Sondaar
 *
 *  License:
 *      Public Domain
 */

#define UDI_VERSION 0x101
#define UDI_FS_VERSION 0x101
#include <udi.h>
#include <udi_fs.h>
#include <udi_env.h>
#include <mos/driver.h>
#include <mos/drivercom.h>
#include <mos/event.h>
#include <stdlib.h>
#include <string.h>

udi_meta_initproc_t udi_decode_udi_fsread_provider;
//static const udi_fs_blockread_provider_ops_t * fsread_meta_pointers;

int handle_fs_mount(int, int, unsigned char *);
int handle_fs_unmount(int, int, unsigned char *);
int handle_fs_invalid(int, int, unsigned char *);
int handle_fs_queryinterface(int, int, unsigned char *);

MOS_EVENTHANDLER gfx_decoder_handles[11] = {
    {&handle_fs_mount},
    {&handle_fs_unmount},
    {&handle_fs_invalid},
    {&handle_fs_invalid},
    {&handle_fs_invalid},
    {&handle_fs_invalid},
    {&handle_fs_invalid},
    {&handle_fs_invalid},
    {&handle_fs_invalid},
    {&handle_fs_invalid},
    {&handle_fs_invalid} };
    
MOS_EVENTHANDLER fs_query_handles[10] = {
    {&handle_fs_queryinterface} };

