' Summary: decode_gio.bas
' Decoder for GIO calls
'
'  Author:
'      Marcel Sondaar
'
'  License:
'      Public Domain
'

#include "mos/gio.bi"
#include "mos/udidecode.bi"
#include "udi.bi"

Type udi_gio_rw_params_t
    offset_lo As Unsigned Integer
    offset_hi As Unsigned Integer
End Type

Type udi_gio_xfer_cb_t
    gcb As udi_cb_t
    op As Unsigned Byte ' udi_gio_op_t
    tr_params As udi_gio_rw_params_t Ptr
    data_buf As Unsigned Integer Ptr 'udi_buf_t * , buf = size_t
End Type

Type udi_gio_provider_ops_t
    channel_event_ind_op As Integer' udi_channel_event_ind_op_t *
    gio_bind_req_op As Integer' udi_gio_bind_req_op_t *
    gio_unbind_req_op As Integer' udi_gio_unbind_req_op_t *
    gio_xfer_req_op As Sub Cdecl (ByVal cb As udi_gio_xfer_cb_t Ptr) ' udi_gio_xfer_req_op_t *
    gio_event_res_op As Integer' udi_gio_event_res_op_t *
End Type

Const UDI_GIO_OP_CUSTOM = 16
Const UDI_GIO_OP_MAX = 64
Const UDI_GIO_DIR_READ = 64
Const UDI_GIO_DIR_WRITE = 128
Const UDI_GIO_OP_READ = UDI_GIO_DIR_READ
Const UDI_GIO_OP_WRITE = UDI_GIO_DIR_WRITE

Sub udi_parse_gio_message(ByVal Source As udi_cb_t Ptr, ByVal Length As Integer, ByVal Message As Byte Ptr, ByVal Customdata as Byte Ptr)
    Dim msgp As Integer Ptr
    Dim metaindex As Integer
    msgp = CPtr(Integer Ptr, message)
    metaindex = CInt(customdata)

    Dim prov As udi_gio_provider_ops_t Ptr
    prov = CPtr(udi_gio_provider_ops_t Ptr, udi_init_info.ops_init_list[metaindex - 1].ops_vector) ' ops indices are 1-based

    If message < 12 then *Cptr(Byte Ptr, &HDE0001) = 0

    Select case msgp[0]
        Case GIOCOMMAND_READ
            Dim cb As udi_gio_xfer_cb_t
            cb.op = UDI_GIO_OP_READ
            cb.gcb = *source

            Dim transfer As udi_gio_rw_params_t
            transfer.offset_lo = msgp[1]
            transfer.offset_hi = 0
            cb.tr_params = @transfer

            Dim size As Unsigned Integer
            size = msgp[2]
            cb.data_buf = @size

            (*prov).gio_xfer_req_op(@cb)
            '*Cptr(Byte Ptr, &HDE0004) = 0

        Case GIOCOMMAND_WRITE
            Dim cb As udi_gio_xfer_cb_t
            cb.op = UDI_GIO_OP_WRITE
            cb.gcb = *source

            Dim transfer As udi_gio_rw_params_t
            transfer.offset_lo = msgp[1]
            transfer.offset_hi = 0
            cb.tr_params = @transfer

            Dim size As Unsigned Integer
            size = msgp[2]
            cb.data_buf = @size
            *Cptr(Byte Ptr, &HDE0003) = 0

        Case Else
            *Cptr(Byte Ptr, &HDE0002) = 0
    End Select
End Sub

Function udi_decode_gio alias "udi_decode_gio" (ByVal index As Integer, ByVal basecb as udi_cb_t Ptr) As protodelegate
    Dim rv As Protodelegate

    rv.opcodebase = GIOCOMMANDBASE
    rv.customdata = CPtr(Byte Ptr, index)
    rv.decoder = @udi_parse_gio_message

    Function = rv
End Function
