'
' Summary: pio_pci.bi
' Initialize PIO regsets for PCI devices
'
' Author:
'     Marcel Sondaar
'
' License:
'      <Public Domain>
'
#include "mos.bi"
#include "mos/devmgr.bi"
#include "mos/driver.bi"
#include "mos/drivercom.bi"
#include "mos/pci.bi"
#include "udi_env.bi"

Declare Sub Bochs_PutInt CDecl Alias "bochs_putu" (ByVal value As Unsigned Integer)
Declare Sub Bochs_PutString CDecl Alias "bochs_puts" (ByVal value As Byte Ptr)
Declare Sub Bochs_PutBString(ByRef text As String)

Sub Bochs_PutBString(ByRef text As String)
    Bochs_PutString(*CPtr(Byte Ptr Ptr, @text))
End Sub


' Function: GetDeviceName
' Synchronously gets the device name from the manager
'
' in:
'     devid - device id
'
' out:
'     return - string device name
'
Function GetDeviceName(ByVal devid As Integer) As String
    Dim i(0 to 1) as Integer
    i(0) = DEVMGRCOMMANDS_GETNAME
    i(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(i(0))) )
    Yield
    While drv_peekmessage() = 0
        Yield
    Wend

    Dim rs as string
    Dim rv As Integer
    rv = drv_peekmessage()
    rs = space$(rv)
    drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))

    Function = rs
End Function

' Function: GetDeviceParent
' Synchronously gets the device parent from the manager
'
' in:
'     devid - device id
'
' out:
'     return - parent device id, or zero on error
'
Function GetDeviceParent(ByVal devid As Integer) As Integer
    Dim msg() as Integer
    ReDim msg(2)
    msg(0) = 1
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    Redim msg((drv_peekmessage() + 3) \ 4)
    drv_readmessage(CPtr(Byte Ptr, @(msg(0)) ) )
    If msg(0) <= 0 Then
        Function = 0
    Else
        Function = msg(1)
    End If    
End Function

' Function: GetDeviceLocation
' Synchronously gets the device name from the manager
'
' in:
'     devid - device id
'
' out:
'     return - string device name
'
Function GetDeviceLocation(ByVal devid As Integer) As String
    Dim i(0 to 1) as Integer
    i(0) = DEVMGRCOMMANDS_GETLOCATION
    i(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(i(0))) )
    Yield
    While drv_peekmessage() = 0
        Yield
    Wend

    Dim rs as string
    Dim rv As Integer
    rv = drv_peekmessage()
    rs = space$(rv)
    drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))

    Function = rs
End Function

Sub _udi_init_pci CDecl Alias "_udi_init_pci" (ByVal devid As Integer)
    Bochs_PutBString "[ PCI initialisation: '"
    
    Dim pcistring As String, pciloc As String
    pcistring = GetDeviceName(devid)
    Bochs_PutBString pcistring
    Bochs_PutBString "' at "
    pciloc = GetDeviceLocation(devid)
    
    Dim pcibus As Integer
    Dim pcidev As Integer
    Dim pcifn As Integer
    
    pcibus = ValInt("&H" + mid$(pciloc, 5, 2))
    pcidev = ValInt("&H" + mid$(pciloc, 8, 2))
    pcifn = ValInt("&H" + mid$(pciloc, 11, 2))
    
    Bochs_PutBString " bus " + str$(pcibus) + " dev " + str$(pcidev) + " fn " + str$(pcifn) + "]" + Chr$(13) + Chr$(10)

    Dim StartAddress As Unsigned Integer
    StartAddress = &H10000000
    
    Dim lp As Integer, address As Unsigned Integer, mask As Unsigned Integer, size As Unsigned Integer
    For lp = 0 to 5    
        address = PCI_bar_readaddress(pcibus, pcidev, pcifn, lp)
        mask = PCI_bar_readmask(pcibus, pcidev, pcifn, lp)
        size = (Not (mask And &HFFFFFFF0)) + 1
        Bochs_PutBString "[BAR " + Str$(lp) + ": 0x" + Hex$(address) + "@0x" + Hex$(mask) + ", 0x" + hex$(size) + " bytes"
        If (mask = 0) Or (mask = &HFFFFFFFF) Then
            ' not used
            Bochs_PutBString " (unused)"
        Elseif (mask And &H1) = &H1 Then
            Bochs_PutBString " (port IO)"
            portalloc address And &HFFF0, size
            _udi_tail_pio_handle lp, _udi_create_pio_port(address And &HFFF0, size)
        Else
            Bochs_PutBString " (MMIO at 0x"
            ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, address))
            Dim lPages As Unsigned Integer
            Dim lBytes As Unsigned Integer
            lPages = (size + &H003FFFFF) \ &H00400000
            lBytes = (size + &H003FFFFF) And &HFFC00000
            Dim realstart As Unsigned Integer
            realstart = StartAddress + (address And &H3FFFFF)
            BlockAllocPhysL lPages, CPtr(Byte Ptr, StartAddress), CPtr(Byte Ptr, address)
            _udi_tail_pio_handle lp, _udi_create_pio_mmio(CPtr(Byte Ptr, realstart), size)
            Bochs_PutBString Hex$(realstart) + ", " + Str$(lPages) + " 4M pages, " + Str$(lBytes) + " mapped)"
            
            StartAddress = StartAddress + lBytes
        End If
        Bochs_PutBString "]" + Chr$(13) + Chr$(10)
    Next lp
    
End Sub