/**
 * Summary: region_enter.c
 * Create a new region
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#define UDI_VERSION 0x101

#include <udi_env.h>
#include <udi.h>
#include <stdlib.h>

mos_region_t * _mos_region_enter()
{
    // allocate buffer
    mos_region_t * region = (mos_region_t*) malloc(sizeof(mos_region_t));
    void * context        = malloc(4096);

    if (region && context)
    {
        region->contextdata = context;
	return region;
    }

    if (region) free(region);
    if (context) free(context);
    return NULL;
}

