' Summary: udimain.bas
' Contains the entry point for UDI drivers
'
'  Author:
'      Marcel Sondaar
'
'  License:
'      Public Domain
'

#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/udidecode.bi"
#include "mos.bi"

Dim Shared delegates() As protodelegate
Dim Shared delegatecount As Integer

Extern udi_props_meta_list Alias "udi_props_meta_list" As protoconfiglist Ptr
Declare Function malloc cdecl Alias "malloc" (size as Unsigned Integer) As Byte Ptr

Sub modmain CDecl Alias "main"
    Dim devno As Integer
    devno = DriverInit() ' get my index
    
    ' set up external communications
    drv_setname(0,1)

    ' set up internal communications
    Dim basecb As udi_cb_t
    basecb.scratch = malloc(4096)
    basecb.context = malloc(4096) ' Fixme: grab the correct size from primary_init_t

    ' initialize metalanguages
    delegatecount = 0
    While udi_props_meta_list[delegatecount].MetaIndex > 0
        delegatecount = delegatecount + 1
    Wend
    Redim delegates(delegatecount)
    Dim lp As Integer
    For lp = 0 to delegatecount - 1
        delegates(lp) = udi_props_meta_list[lp].Initializer(udi_props_meta_list[lp].MetaIndex, @basecb)
    Next lp

    ' register driver in device manager
    dim msg(0 to 1) As Integer
    msg(0) = 7
    msg(1) = devno
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )

    While 1 = 1
        Dim msglen As Integer
        msglen = 0
        While msglen = 0
            msglen = drv_peekmessage()
            If msglen = 0 Then Yield
        Wend
        Dim rs As String
        Dim sender As Integer
        rs = space$(msglen)

        Dim msgp As Byte Ptr
        msgp = *CPtr(Byte Ptr Ptr, @rs)

        sender = drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))

        If msglen >= 4 Then
            Dim msgid As Integer
            msgid = *CPtr(Integer Ptr, msgp)
            For lp = 0 to delegatecount - 1
                If (msgid And &HFFFF0000) = delegates(lp).opcodebase Then
                    delegates(lp).decoder(@basecb, msglen, msgp, delegates(lp).customdata)
                    msgid = -1
                    Exit For
                End if
            Next lp
            If msgid <> -1 Then
                *Cptr(Byte Ptr, (msgid SHR 16) + &HD10000) = 0
            End If
        End If
    Wend

End Sub
