'
' Summary: udi_env.bi
' contains environment-specific UDI definitions
'
' Author:
'     Marcel Sondaar
'
' License:
'      <Public Domain>
'

Declare Function _udi_setregioncount CDecl Alias "_udi_setregioncount" (ByVal regions As Integer) As Integer
Declare Function _udi_getregiondata CDecl Alias "_udi_getregiondata" (ByVal index As Integer) As Byte Ptr
Declare Sub _udi_cleanregiondata CDecl Alias "_udi_cleanregiondata"

' Structure: mos_pio_impl_t
' Contains the functions to perform PIO instructions
Type mos_pio_impl_t
    write_8 As Sub CDecl(ByVal impl As mos_pio_impl_t Ptr, ByVal offset As Unsigned Integer, ByVal value As Unsigned Byte)
    write_16 As Sub CDecl(ByVal impl As mos_pio_impl_t Ptr, ByVal offset As Unsigned Integer, ByVal value As Unsigned Short)
    write_32 As Sub CDecl(ByVal impl As mos_pio_impl_t Ptr, ByVal offset As Unsigned Integer, ByVal value As Unsigned Integer)
    read_8 As Function (ByVal impl As mos_pio_impl_t Ptr, ByVal offset As Unsigned Integer) As Unsigned Byte
    read_16 As Function (ByVal impl As mos_pio_impl_t Ptr, ByVal offset As Unsigned Integer) As Unsigned Short
    read_32 As Function (ByVal impl As mos_pio_impl_t Ptr, ByVal offset As Unsigned Integer) As Unsigned Integer
    
    ' Variable: limit
    ' The size of the accessible area (for safety checking)
    limit As Unsigned Integer
End Type

Declare Function _udi_create_pio_mmio CDecl Alias "_udi_create_pio_mmio" (ByVal base As Unsigned Byte Ptr, ByVal length As Unsigned Integer) As mos_pio_impl_t Ptr
Declare Function _udi_create_pio_port CDecl Alias "_udi_create_pio_port" (ByVal base As Unsigned Short, ByVal length As Unsigned Integer) As mos_pio_impl_t Ptr
Declare Sub _udi_tail_pio_handle CDecl Alias "_udi_tail_pio_handle" (ByVal regset_idx As Integer, ByVal impl As mos_pio_impl_t Ptr)

' Structure: mos_pio_handle_list
' List of available PIO regsets
Type mos_pio_handle_list_t
    regset_idx As Unsigned Integer
    handlers   As mos_pio_impl_t Ptr
    nextptr    As mos_pio_handle_list_t Ptr
End Type

Extern mos_pio_handle_list_head Alias "mos_pio_handle_list_head" As mos_pio_handle_list_t Ptr
