/**
 * Summary: udi_gfx.c
 * UDIGraphics Metalanguage implementation
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#define UDI_VERSION 0x101
#define UDI_GFX_VERSION 0x101
#define UDI_ANNOY_ME
#include <udi.h>
#include <udi_gfx.h>

// direct call stub prototypes
static udi_mei_direct_stub_t udi_gfx_bind_req_direct;
static udi_mei_direct_stub_t udi_gfx_bind_ack_direct;
static udi_mei_direct_stub_t udi_gfx_unbind_req_direct;
static udi_mei_direct_stub_t udi_gfx_unbind_ack_direct;
static udi_mei_direct_stub_t udi_gfx_set_connector_req_direct;
static udi_mei_direct_stub_t udi_gfx_set_connector_ack_direct;
static udi_mei_direct_stub_t udi_gfx_set_engine_req_direct;
static udi_mei_direct_stub_t udi_gfx_set_engine_ack_direct;
static udi_mei_direct_stub_t udi_gfx_get_connector_req_direct;
static udi_mei_direct_stub_t udi_gfx_get_connector_ack_direct;
static udi_mei_direct_stub_t udi_gfx_get_engine_req_direct;
static udi_mei_direct_stub_t udi_gfx_get_engine_ack_direct;
static udi_mei_direct_stub_t udi_gfx_range_connector_req_direct;
static udi_mei_direct_stub_t udi_gfx_range_connector_ack_direct;
static udi_mei_direct_stub_t udi_gfx_range_engine_req_direct;
static udi_mei_direct_stub_t udi_gfx_range_engine_ack_direct;
static udi_mei_direct_stub_t udi_gfx_engine_command_req_direct;
static udi_mei_direct_stub_t udi_gfx_engine_command_ack_direct;

// backend stub prototypes
static udi_mei_backend_stub_t udi_gfx_bind_req_backend;
static udi_mei_backend_stub_t udi_gfx_bind_ack_backend;
static udi_mei_backend_stub_t udi_gfx_unbind_req_backend;
static udi_mei_backend_stub_t udi_gfx_unbind_ack_backend;
static udi_mei_backend_stub_t udi_gfx_set_connector_req_backend;
static udi_mei_backend_stub_t udi_gfx_set_connector_ack_backend;
static udi_mei_backend_stub_t udi_gfx_set_engine_req_backend;
static udi_mei_backend_stub_t udi_gfx_set_engine_ack_backend;
static udi_mei_backend_stub_t udi_gfx_get_connector_req_backend;
static udi_mei_backend_stub_t udi_gfx_get_connector_ack_backend;
static udi_mei_backend_stub_t udi_gfx_get_engine_req_backend;
static udi_mei_backend_stub_t udi_gfx_get_engine_ack_backend;
static udi_mei_backend_stub_t udi_gfx_range_connector_req_backend;
static udi_mei_backend_stub_t udi_gfx_range_connector_ack_backend;
static udi_mei_backend_stub_t udi_gfx_range_engine_req_backend;
static udi_mei_backend_stub_t udi_gfx_range_engine_ack_backend;
static udi_mei_backend_stub_t udi_gfx_engine_command_req_backend;
static udi_mei_backend_stub_t udi_gfx_engine_command_ack_backend;

// ops indices
#define UDI_GFX_BIND_REQ_OP         1
#define UDI_GFX_UNBIND_REQ_OP       2
#define UDI_GFX_SET_CON_REQ_OP      3
#define UDI_GFX_SET_E_REQ_OP        4
#define UDI_GFX_GET_CON_REQ_OP      5
#define UDI_GFX_GET_E_REQ_OP        6
#define UDI_GFX_RANGE_CON_REQ_OP    7
#define UDI_GFX_RANGE_E_REQ_OP      8
#define UDI_GFX_COMMAND_REQ_OP      9

#define UDI_GFX_BIND_ACK_OP         1
#define UDI_GFX_UNBIND_ACK_OP       2
#define UDI_GFX_SET_CON_ACK_OP      3
#define UDI_GFX_SET_E_ACK_OP        4
#define UDI_GFX_GET_CON_ACK_OP      5
#define UDI_GFX_GET_E_ACK_OP        6
#define UDI_GFX_RANGE_CON_ACK_OP    7
#define UDI_GFX_RANGE_E_ACK_OP      8
#define UDI_GFX_COMMAND_ACK_OP      9

// CB layouts
udi_layout_t udi_gfx_bind_cb_layout[] = 
{ 
    UDI_DL_END 
};

udi_layout_t udi_gfx_state_cb_layout[] = 
{ 
    UDI_DL_UBIT32_T, // component
    UDI_DL_UBIT32_T, // attribute
    UDI_DL_END 
};

udi_layout_t udi_gfx_range_cb_req_layout[] = 
{ 
    UDI_DL_UBIT32_T, // component
    UDI_DL_UBIT32_T, // attribute
    UDI_DL_BUF, 0, 0, 1, // argument buffer, do not define content
    UDI_DL_END 
};
udi_layout_t udi_gfx_range_cb_ack_layout[] = 
{ 
    UDI_DL_UBIT32_T, // component
    UDI_DL_UBIT32_T, // attribute
    UDI_DL_BUF, 0, 0, 0, // argument buffer, content matters
    UDI_DL_END 
};

udi_layout_t udi_gfx_command_cb_req_layout[] = 
{ 
    UDI_DL_BUF, 0, 0, 0, // command data
    UDI_DL_END 
};
udi_layout_t udi_gfx_command_cb_ack_layout[] = 
{ 
    UDI_DL_BUF, 0, 0, 0, // reply data
    UDI_DL_END 
};

// argument layouts
udi_layout_t udi_gfx_no_arguments[] = 
{ 
    UDI_DL_END 
};

udi_layout_t udi_gfx_bind_ack_arguments[] = 
{ 
    UDI_DL_INDEX_T,  // connectors
    UDI_DL_INDEX_T,  // engines
    UDI_DL_STATUS_T, // status
    UDI_DL_END 
};

udi_layout_t udi_gfx_get_state_ack_arguments[] = 
{
    UDI_DL_UBIT32_T, // value
    UDI_DL_END
};

udi_layout_t udi_gfx_set_state_req_arguments[] = 
{
    UDI_DL_UBIT32_T, // value
    UDI_DL_END
};

udi_mei_op_template_t gfx_client_op_templates[] =
{
    //udi_channel_event_ind_op_t          *channel_event_ind_op;
    //automatically added
    {
        "udi_gfx_bind_ack",
        UDI_MEI_OPCAT_ACK,
        0,
        UDI_GFX_BIND_CB_NUM,
        0,0,0,0,
        udi_gfx_bind_ack_direct, 
        udi_gfx_bind_ack_backend,
        udi_gfx_bind_cb_layout,
        udi_gfx_bind_ack_arguments
    },
    {
        "udi_gfx_unbind_ack",
        UDI_MEI_OPCAT_ACK,
        0,
        UDI_GFX_BIND_CB_NUM,
        0,0,0,0,
        udi_gfx_unbind_ack_direct, udi_gfx_unbind_ack_backend,
        udi_gfx_bind_cb_layout,
        udi_gfx_no_arguments
    },
    {
        "udi_gfx_set_connector_ack",
        UDI_MEI_OPCAT_ACK,
        0,
        UDI_GFX_STATE_CB_NUM,
        0,0,0,0,
        udi_gfx_set_connector_ack_direct, udi_gfx_set_connector_ack_backend,
        udi_gfx_state_cb_layout,
        udi_gfx_no_arguments
    },
    {
        "udi_gfx_set_engine_ack",
        UDI_MEI_OPCAT_ACK,
        0,
        UDI_GFX_STATE_CB_NUM,
        0,0,0,0,
        udi_gfx_set_engine_ack_direct, udi_gfx_set_engine_ack_backend,
        udi_gfx_state_cb_layout,
        udi_gfx_no_arguments
    },
    {
        "udi_gfx_get_connector_ack",
        UDI_MEI_OPCAT_ACK,
        0,
        UDI_GFX_STATE_CB_NUM,
        0,0,0,0,
        udi_gfx_get_connector_ack_direct, udi_gfx_get_connector_ack_backend,
        udi_gfx_state_cb_layout,
        udi_gfx_get_state_ack_arguments
    },
    {
        "udi_gfx_get_engine_ack",
        UDI_MEI_OPCAT_ACK,
        0,
        UDI_GFX_STATE_CB_NUM,
        0,0,0,0,
        udi_gfx_get_engine_ack_direct, udi_gfx_get_engine_ack_backend,
        udi_gfx_state_cb_layout,
        udi_gfx_get_state_ack_arguments
    },
    {
        "udi_gfx_range_connector_ack",
        UDI_MEI_OPCAT_ACK,
        0,
        UDI_GFX_RANGE_CB_NUM,
        0,0,0,0,
        udi_gfx_range_connector_ack_direct, udi_gfx_range_connector_ack_backend,
        udi_gfx_range_cb_ack_layout,
        udi_gfx_no_arguments
    },
    {
        "udi_gfx_range_engine_ack",
        UDI_MEI_OPCAT_ACK,
        0,
        UDI_GFX_RANGE_CB_NUM,
        0,0,0,0,
        udi_gfx_range_engine_ack_direct, udi_gfx_range_engine_ack_backend,
        udi_gfx_range_cb_ack_layout,
        udi_gfx_no_arguments
    },
    {
        "udi_gfx_command_ack",
        UDI_MEI_OPCAT_ACK,
        0,
        UDI_GFX_COMMAND_CB_NUM,
        0,0,0,0,
        udi_gfx_engine_command_ack_direct, udi_gfx_engine_command_ack_backend,
        udi_gfx_command_cb_ack_layout,
        udi_gfx_no_arguments
    },
    
    {NULL, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL}
};

udi_mei_op_template_t gfx_provider_op_templates[] =
{    
    //udi_channel_event_ind_op_t          *channel_event_ind_op;
    //automatically added
    //udi_gfx_bind_req_op_t               *gfx_bind_req_op;
    {
        "udi_gfx_bind_req",
        UDI_MEI_OPCAT_REQ,
        0,
        UDI_GFX_BIND_CB_NUM,
        0,0,0,0,
        udi_gfx_bind_req_direct, udi_gfx_bind_req_backend,
        udi_gfx_bind_cb_layout,
        udi_gfx_no_arguments
    },
    //udi_gfx_unbind_req_op_t             *gfx_unbind_req_op;
    {
        "udi_gfx_unbind_req",
        UDI_MEI_OPCAT_REQ,
        0,
        UDI_GFX_BIND_CB_NUM,
        0,0,0,0,
        udi_gfx_unbind_req_direct, udi_gfx_unbind_req_backend,
        udi_gfx_bind_cb_layout,
        udi_gfx_no_arguments
    },
    //udi_gfx_set_connector_req_op_t      *gfx_set_connector_req_op;
    {
        "udi_gfx_set_connector_req",
        UDI_MEI_OPCAT_REQ,
        0,
        UDI_GFX_STATE_CB_NUM,
        0,0,0,0,
        udi_gfx_set_connector_req_direct, udi_gfx_set_connector_req_backend,
        udi_gfx_state_cb_layout,
        udi_gfx_set_state_req_arguments
    },
    //udi_gfx_set_engine_req_op_t         *gfx_set_engine_req_op;
    {
        "udi_gfx_set_engine_req",
        UDI_MEI_OPCAT_REQ,
        0,
        UDI_GFX_STATE_CB_NUM,
        0,0,0,0,
        udi_gfx_set_engine_req_direct, udi_gfx_set_engine_req_backend,
        udi_gfx_state_cb_layout,
        udi_gfx_set_state_req_arguments
    },
    //udi_gfx_get_connector_req_op_t      *gfx_get_connector_req_op;
    {
        "udi_gfx_get_connector_req",
        UDI_MEI_OPCAT_REQ,
        0,
        UDI_GFX_STATE_CB_NUM,
        0,0,0,0,
        udi_gfx_get_connector_req_direct, udi_gfx_get_connector_req_backend,
        udi_gfx_state_cb_layout,
        udi_gfx_no_arguments
    },
    //udi_gfx_get_engine_req_op_t         *gfx_get_engine_req_op;
    {
        "udi_gfx_get_engine_req",
        UDI_MEI_OPCAT_REQ,
        0,
        UDI_GFX_STATE_CB_NUM,
        0,0,0,0,
        udi_gfx_get_engine_req_direct, udi_gfx_get_engine_req_backend,
        udi_gfx_state_cb_layout,
        udi_gfx_no_arguments
    },
    //udi_gfx_range_connector_req_op_t    *gfx_range_connector_req_op;
    {
        "udi_gfx_range_connector_req",
        UDI_MEI_OPCAT_REQ,
        0,
        UDI_GFX_RANGE_CB_NUM,
        0,0,0,0,
        udi_gfx_range_connector_req_direct, udi_gfx_range_connector_req_backend,
        udi_gfx_range_cb_req_layout,
        udi_gfx_no_arguments
    },
    //udi_gfx_range_engine_req_op_t       *gfx_range_engine_req_op;
    {
        "udi_gfx_range_engine_req",
        UDI_MEI_OPCAT_REQ,
        0,
        UDI_GFX_RANGE_CB_NUM,
        0,0,0,0,
        udi_gfx_range_engine_req_direct, udi_gfx_range_engine_req_backend,
        udi_gfx_range_cb_req_layout,
        udi_gfx_no_arguments
    },
    //udi_gfx_command_op_t                *gfx_command_op;
    {
        "udi_gfx_command_req",
        UDI_MEI_OPCAT_REQ,
        0,
        UDI_GFX_COMMAND_CB_NUM,
        0,0,0,0,
        udi_gfx_engine_command_req_direct, udi_gfx_engine_command_req_backend,
        udi_gfx_command_cb_req_layout,
        udi_gfx_no_arguments
    },
    
    {NULL, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL}
};

udi_mei_ops_vec_template_t gfx_ops_vec_template_list[] = 
{
    {
        UDI_GFX_PROVIDER_OPS_NUM,
        UDI_MEI_REL_EXTERNAL | UDI_MEI_REL_BIND,
        gfx_provider_op_templates
    },
    {
        UDI_GFX_CLIENT_OPS_NUM,
        UDI_MEI_REL_EXTERNAL | UDI_MEI_REL_BIND | UDI_MEI_REL_INITIATOR,
        gfx_client_op_templates
    },
    {
        0, 0, NULL
    }
};

// root metalanguage structure
udi_mei_init_t udi_meta_info = {
    gfx_ops_vec_template_list,
    NULL //TODO: gfx_mei_enumeration_rank
};


// Bind Stubs
UDI_MEI_STUBS(udi_gfx_bind_req, udi_gfx_bind_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_PROVIDER_OPS_NUM, UDI_GFX_BIND_REQ_OP)

UDI_MEI_STUBS(udi_gfx_bind_ack, udi_gfx_bind_cb_t,
          3, (sockets, engines, status),
         (udi_index_t, udi_index_t, udi_status_t),
         (UDI_VA_INDEX_T, UDI_VA_INDEX_T, UDI_VA_STATUS_T),
          UDI_GFX_CLIENT_OPS_NUM, UDI_GFX_BIND_ACK_OP)

UDI_MEI_STUBS(udi_gfx_unbind_req, udi_gfx_bind_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_PROVIDER_OPS_NUM, UDI_GFX_UNBIND_REQ_OP)

UDI_MEI_STUBS(udi_gfx_unbind_ack, udi_gfx_bind_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_CLIENT_OPS_NUM, UDI_GFX_UNBIND_ACK_OP)

// Setter stubs
UDI_MEI_STUBS(udi_gfx_set_connector_req, udi_gfx_state_cb_t,
          1, (value),
         (udi_ubit32_t),
         (UDI_VA_UBIT32_T),
          UDI_GFX_PROVIDER_OPS_NUM, UDI_GFX_SET_CON_REQ_OP)

UDI_MEI_STUBS(udi_gfx_set_connector_ack, udi_gfx_state_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_CLIENT_OPS_NUM, UDI_GFX_SET_CON_ACK_OP)

UDI_MEI_STUBS(udi_gfx_set_engine_req, udi_gfx_state_cb_t,
          1, (value),
         (udi_ubit32_t),
         (UDI_VA_UBIT32_T),
          UDI_GFX_PROVIDER_OPS_NUM, UDI_GFX_SET_E_REQ_OP)

UDI_MEI_STUBS(udi_gfx_set_engine_ack, udi_gfx_state_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_CLIENT_OPS_NUM, UDI_GFX_SET_E_ACK_OP)

// Getter stubs
UDI_MEI_STUBS(udi_gfx_get_connector_req, udi_gfx_state_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_PROVIDER_OPS_NUM, UDI_GFX_GET_CON_REQ_OP)

UDI_MEI_STUBS(udi_gfx_get_connector_ack, udi_gfx_state_cb_t,
          1, (value),
         (udi_ubit32_t),
         (UDI_VA_UBIT32_T),
          UDI_GFX_CLIENT_OPS_NUM, UDI_GFX_GET_CON_ACK_OP)

UDI_MEI_STUBS(udi_gfx_get_engine_req, udi_gfx_state_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_PROVIDER_OPS_NUM, UDI_GFX_GET_E_REQ_OP)

UDI_MEI_STUBS(udi_gfx_get_engine_ack, udi_gfx_state_cb_t,
          1, (value),
         (udi_ubit32_t),
         (UDI_VA_UBIT32_T),
          UDI_GFX_CLIENT_OPS_NUM, UDI_GFX_GET_E_ACK_OP)

// Range stubs
UDI_MEI_STUBS(udi_gfx_range_connector_req, udi_gfx_range_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_PROVIDER_OPS_NUM, UDI_GFX_RANGE_CON_REQ_OP)

UDI_MEI_STUBS(udi_gfx_range_connector_ack, udi_gfx_range_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_CLIENT_OPS_NUM, UDI_GFX_RANGE_CON_ACK_OP)

UDI_MEI_STUBS(udi_gfx_range_engine_req, udi_gfx_range_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_PROVIDER_OPS_NUM, UDI_GFX_RANGE_E_REQ_OP)

UDI_MEI_STUBS(udi_gfx_range_engine_ack, udi_gfx_range_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_CLIENT_OPS_NUM, UDI_GFX_RANGE_E_ACK_OP)

// Command stubs
UDI_MEI_STUBS(udi_gfx_engine_command_req, udi_gfx_command_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_PROVIDER_OPS_NUM, UDI_GFX_COMMAND_REQ_OP)

UDI_MEI_STUBS(udi_gfx_engine_command_ack, udi_gfx_command_cb_t,
          0, (),
         (),
         (),
          UDI_GFX_CLIENT_OPS_NUM, UDI_GFX_COMMAND_ACK_OP)
