/**
 * Summary: exec.c
 * Execute an IO transfer list
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

udi_ubit16_t _udi_pio_execute_sw(udi_pio_trans_t * opcodes, int len, udi_size_t regsize, void * scratch, udi_buf_t * buf, void * mem, void * io)
{
    // TODO: assumes udi_trans_size <= 2;
    udi_ubit32_t regs[8];
    udi_ubit32_t regmask = 0xff;
    for (int i = 1; i <= regsize; i++)
    {
        regmask = (regmask << (8 * i)) | regmask;
    }

    for (udi_size_t offset = 0; offset < len; offset++)
    {
        udi_ubit8_t opcode = opcodes[offset].pio_op;
        if (opcode < 0x80)
        {
            // Class A
            udi_ubit8_t reg = opcode & 0x07;
            udi_ubit8_t rm = opcode & 0x18;
            udi_ubit8_t op = opcode & 0xE0;
            if (op == UDI_PIO_OUT || op == UDI_PIO_LOAD)
            {
                udi_ubit32_t intermediate;
                switch(rm)
                {
                    case UDI_PIO_DIRECT:
                        intermediate = regs[reg];
                        break;
                    
                    case UDI_PIO_SCRATCH:
                    {
                        // TODO: fix issues with bus alignments,
                        char * address = (char*)scratch + regs[reg];
                        intermediate = *(udi_ubit32_t *)address;
                    }
                    break;                    
                    
                    case UDI_PIO_BUF:
                    {
                        udi_assert(buf != NULL)
                    }
                    break;
                    
                    case UDI_PIO_MEM:
                    default:
                    {
                        char * address = (char*)mem + regs[reg];
                        intermediate = *(udi_ubit32_t *)address;
                    }
                }
                
                if (op == UDI_PIO_LOAD)
                {
                    regs[operand & 0x7]
                
            }
        }
        else if (opcode < 0xF0)
        {
            // Class B
        }
        else // F0..FF
        {
            // Class C
        }
    }
    return 0;
}
