/**
 * Summary: pio_additem.c
 * Add pio emitter to the list
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <udi_env.h>
#include <stdlib.h>

mos_pio_handle_list_t * mos_pio_handle_list_head = NULL;

void _udi_tail_pio_handle(udi_ubit32_t regset_idx, mos_pio_impl_t * impl)
{
    mos_pio_handle_list_t * item = (mos_pio_handle_list_t *) malloc(sizeof(mos_pio_handle_list_t));
    udi_assert(item != NULL);
    
    item->handlers = impl;
    item->regset_idx = regset_idx;
    item->next = mos_pio_handle_list_head;
    mos_pio_handle_list_head = item;
}
