/**
 * Summary: pio_map.c
 * Mapping physical IO transactions
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#define UDI_VERSION 0x101
#define UDI_PHYSIO_VERSION 0x101

#include <udi.h>
#include <udi_physio.h>
#include <udi_env.h>

//#include <mos.h>
#include <stdlib.h> // malloc
#include <string.h> // memcpy

void udi_pio_map (
    udi_pio_map_call_t *callback,
    udi_cb_t *gcb,
    udi_ubit32_t regset_idx,
    udi_ubit32_t base_offset,
    udi_ubit32_t length,
    udi_pio_trans_t *trans_list,
    udi_ubit16_t list_length,
    udi_ubit16_t pio_attributes,
    udi_ubit32_t pace,
    udi_index_t serialization_domain )
{    
    
    if (pio_attributes) if (pace) if (serialization_domain) {} // TODO: fix missing details
 
    mos_pio_handle_list_t * head = mos_pio_handle_list_head;    
    mos_pio_impl_t * backend = NULL;
    while (head)
    {
        if (head->regset_idx == regset_idx)
        {
            backend = head->handlers;
            break;
        }
        head = head->next;
    }
    udi_assert(backend != NULL);
 
    // copy ucode
    udi_pio_trans_internal_t * tl = (udi_pio_trans_internal_t *) malloc(sizeof(udi_pio_trans_internal_t));
    if (!tl) udi_assert(0);
    tl->opcodecount = list_length;
    tl->opcodes = (udi_pio_local_trans_t *) malloc(list_length *  sizeof(udi_pio_trans_t));
    memcpy(tl->opcodes, trans_list, list_length * sizeof(udi_pio_trans_t));
    tl->regoffset = base_offset;
    tl->regsize = length;
    tl->index = regset_idx;
    tl->ioaccess = backend;

    //return handle
    callback(gcb, (udi_pio_handle_t) tl);
}
