/**
 * Summary: pio_unmap.c
 * unmapping physical IO transactions
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#define UDI_VERSION 0x101
#define UDI_PHYSIO_VERSION 0x101

#include <udi.h>
#include <udi_physio.h>
#include <udi_env.h>

#include <stdlib.h>

void udi_pio_unmap (udi_pio_handle_t pio_handle)
{
    udi_pio_trans_internal_t * trans = (udi_pio_trans_internal_t *) pio_handle;
    free(trans->opcodes);
    free(trans);
}
