/**
 * Summary: pio_x86port.c
 * Port access stubs for PIO handling
 * 
 * Limited to x86 architectures.
 * 
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#define UDI_VERSION 0x101

#include <udi_env.h>
#include <udi.h>
#include <stdlib.h>
#include <x86.h>

static void _udi_port_write_8  (struct mos_pio_impl * impl, udi_size_t offset, udi_ubit8_t data)
{
    mos_port_pio_impl_t * mmio = (mos_port_pio_impl_t *) impl;
    outportb(mmio->base + offset, data);
}

static void _udi_port_write_16 (struct mos_pio_impl * impl, udi_size_t offset, udi_ubit16_t data)
{
    mos_port_pio_impl_t * mmio = (mos_port_pio_impl_t *) impl;
    outportw(mmio->base + offset, data);
}

static void _udi_port_write_32 (struct mos_pio_impl * impl, udi_size_t offset, udi_ubit32_t data)
{
    mos_port_pio_impl_t * mmio = (mos_port_pio_impl_t *) impl;
    outportd(mmio->base + offset, data);
}

static udi_ubit8_t  _udi_port_read_8   (struct mos_pio_impl * impl, udi_size_t offset)
{
    mos_port_pio_impl_t * mmio = (mos_port_pio_impl_t *) impl;
    return inportb(mmio->base + offset);
}

static udi_ubit16_t _udi_port_read_16  (struct mos_pio_impl * impl, udi_size_t offset)
{
    mos_port_pio_impl_t * mmio = (mos_port_pio_impl_t *) impl;
    return inportw(mmio->base + offset);
}

static udi_ubit32_t _udi_port_read_32  (struct mos_pio_impl * impl, udi_size_t offset)
{
    mos_port_pio_impl_t * mmio = (mos_port_pio_impl_t *) impl;
    return inportd(mmio->base + offset);
}

mos_pio_impl_t * _udi_create_pio_port(udi_ubit16_t base, udi_size_t length)
{
    mos_port_pio_impl_t * impl = (mos_port_pio_impl_t *) malloc(sizeof(mos_port_pio_impl_t)); 
    udi_assert(impl != NULL);
    udi_assert(length <= 0x10000);
    
    impl->pio_impl.read_8   = &_udi_port_read_8;
    impl->pio_impl.read_16  = &_udi_port_read_16;
    impl->pio_impl.read_32  = &_udi_port_read_32;
    impl->pio_impl.write_8  = &_udi_port_write_8;
    impl->pio_impl.write_16 = &_udi_port_write_16;
    impl->pio_impl.write_32 = &_udi_port_write_32;
    impl->pio_impl.limit = length;
    impl->base = base;
    return &(impl->pio_impl);
}

