/* Summary: udigen.h
 * Header file for the udigen tool.
 *
 * Author:
 *     Marcel "(Com)Buster" Sondaar
 *
 * License:
 *     <Public Domain>
 *
 */
#ifndef _UDI_UDIGEN_H_
#define _UDI_UDIGEN_H_

#include <stdint.h>
#include <stdio.h>

#define ARCH_I386 1

typedef struct udiprops_message_tuple
{
    int number;
    int disaster;
    unsigned char * content;
    unsigned char * locale;
} udiprops_message_tuple;

typedef struct udiprops_keyconstraint_tuple
{
    char * key;    
    char * value;
    int type;
} udiprops_keyconstraint_tuple;

#define TYPE_STRING 1
#define TYPE_UBIT32 2
#define TYPE_BOOL 3
#define TYPE_BYTEARRAY 4


typedef struct udiprops_configitem_tuple
{
    udiprops_keyconstraint_tuple * key_and_default;
    char ** value_alternatives;
    int optionmode;
    uint32_t min;
    uint32_t max;
    uint32_t stride;
} udiprops_configitem_tuple;
#define OPTION_ANY 1
#define OPTION_ONLY 2
#define OPTION_RANGE 3
#define OPTION_MUTEX 4

typedef struct udiprops_configchoice_tuple
{
    int devicename;
    udiprops_configitem_tuple ** config_items;
    
} udiprops_configchoice_tuple;

typedef struct udiprops_device_tuple
{
    unsigned int devicename;
    unsigned int metaname;
    udiprops_keyconstraint_tuple ** constraints;
} udiprops_device_tuple;

typedef struct udiprops_dependency_tuple
{
    unsigned char * dependency_name;
    uint32_t version;
} udiprops_dependency_tuple;

typedef struct udiprops_metalanguage_tuple
{
    unsigned char * meta_name;
    int binding;
} udiprops_metalanguage_tuple;

typedef struct udiprops_bind_tuple
{
    int meta_index;
    int region_index;
    int ops_index;
    int cb_index;
} udiprops_bind_tuple;

typedef struct udiprops_sourceset_tuple
{
    unsigned char * compile_options;
    unsigned char ** source_files;
} udiprops_sourceset_tuple;

typedef struct udiprops_region_tuple
{
    int index;
    udiprops_metalanguage_tuple ** metalanguages;
} udiprops_region_tuple;

typedef struct udiprops_module_tuple
{
    unsigned char * module_name;
    udiprops_region_tuple ** regions;
    udiprops_dependency_tuple ** dependencies;
    udiprops_dependency_tuple ** exports;
} udiprops_module_tuple;

typedef struct udiprops_symbol_tuple
{
    unsigned char * export_name;
    unsigned char * real_name;
} udiprops_symbol_tuple;

typedef struct udi_udiprops_parse_t
{
    uint8_t ver_major;
    uint8_t ver_minor;
        
    int drivermeta;
    
    unsigned int supplier;
    intptr_t * contact;
    unsigned int name;
    unsigned char * shortname;    
    uint32_t release_no;
    unsigned char * release_str;
    unsigned int category;
  
    udiprops_message_tuple ** messages;
    udiprops_device_tuple ** devices; 
    udiprops_configchoice_tuple ** configurations;
    udiprops_module_tuple ** modules;
    udiprops_dependency_tuple ** global_dependencies;
    udiprops_bind_tuple ** parent_bindings;
    udiprops_bind_tuple ** child_bindings;
    udiprops_sourceset_tuple ** source_sets;
    udiprops_symbol_tuple ** symbols;
    
    udiprops_module_tuple * active_module;
    udiprops_region_tuple * active_region;
    udiprops_sourceset_tuple * active_sourceset;
    
} udi_udiprops_parse_t;

udi_udiprops_parse_t *  udi_parse_propsfile     (FILE * f);
void                    udi_free_udiprops_parse (udi_udiprops_parse_t *);
int                     udi_parse_line          (udi_udiprops_parse_t *, const unsigned char * line, int linecounter);

void free_module_tuple(void *);
void free_region_tuple(void *);
void free_sourceset_tuple(void *);
void free_bind_tuple(void *);
void free_metalanguage_tuple(void *);
void free_dependency_tuple(void *);
void free_device_tuple(void *);
void free_configchoice_tuple(void *);
void free_configitem_tuple(void *);
void free_keyconstraint_tuple(void *);
void free_message_tuple(void *);
void free_symbol_tuple(void *);

int emit_asm(FILE *, udi_udiprops_parse_t *, int);

#endif
