;
; Summary: ati_v8086.asm
; big hack to set an video mode
;
; Author:
;     Marcel Sondaar
;
; License:
;     Educational Purposes
;

%include "inc_syscall.asm"

SECTION .text

global ATI_Setmode

[Bits 32]
ATI_Setmode:

    PUSH EBX
    PUSH ESI
    PUSH EDI

    MOV EBX, 1
    MOV ESI, 0x10000
    MOV EDI, 0x10000
    kernel MemMap

    CLD
    MOV ESI, VTask
    MOV EDI, 0x10000
    MOV ECX, VTask.end - VTask
    REP MOVSB

    MOV EBX, 0x10000000
    MOV EDI, 0xAD000000
    kernel CreateVTask

    POP EDI
    POP ESI
    POP EBX

.loop:
    CMP byte [0x10400], 0
    JE .loop

    RET

[Bits 16]
VTask:

    PUSH CS
    POP AX
    MOV DS, AX
    MOV ES, AX
    MOV SS, AX
    MOV ESP, 0x400

    MOV AX, 0x4F02
    MOV BX, 0x0101
    PUSHF
    CALL FAR 0xC000:0x1312

    MOV byte [0x400], 1

    JMP $

    TIMES 0x400-($-VTask) DB 0
.done:
    DD 0
.end: